/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.ui.Element;
import snownee.jade.overlay.DisplayHelper;

public class ItemStackElement
extends Element {
    private final ItemStack item;
    private final float scale;
    private final @Nullable String text;

    private ItemStackElement(ItemStack item, float scale, @Nullable String text) {
        this.item = item;
        this.scale = scale == 0.0f ? 1.0f : scale;
        this.text = text;
        this.width = this.height = Mth.floor((float)(18.0f * scale));
    }

    public static ItemStackElement of(ItemStack stack) {
        return ItemStackElement.of(stack, 1.0f);
    }

    public static ItemStackElement of(ItemStack stack, float scale) {
        return ItemStackElement.of(stack, scale, null);
    }

    public static ItemStackElement of(ItemStack stack, float scale, @Nullable String text) {
        return new ItemStackElement(stack, scale, text);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.item.isEmpty()) {
            return;
        }
        if (mouseX != -1 && this.getRectangle().containsPoint(mouseX, mouseY)) {
            ItemStackElement.setHoverEffect(graphics, (HoverEvent)new HoverEvent.ShowItem(this.item));
        }
        DisplayHelper.INSTANCE.drawItem(graphics, this.getX() + 1, this.getY() + 1, this.item, this.scale, this.text);
    }

    @Override
    public @Nullable Component getNarration() {
        if (this.item.isEmpty()) {
            return null;
        }
        return Component.literal((String)"%s %s".formatted(this.item.getCount(), this.item.getHoverName().getString()));
    }

    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public boolean copyToClipboard(KeyboardHandler keyboardHandler) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (this.item.isEmpty() || connection == null) {
            return false;
        }
        ItemInput itemInput = new ItemInput(this.item.getItemHolder(), this.item.getComponentsPatch());
        keyboardHandler.setClipboard(itemInput.serialize((HolderLookup.Provider)connection.registryAccess()));
        return true;
    }
}

