/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiMetadataSection;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.Orientation;
import snownee.jade.api.ui.Rect2f;
import snownee.jade.impl.ui.ProgressOverlayElement;
import snownee.jade.overlay.DisplayHelper;

public class SpriteElement
extends ProgressOverlayElement {
    private final RenderPipeline renderPipeline;
    private final Identifier sprite;
    public @Nullable Orientation tiledOrientation;
    private final int oWidth;
    private final int oHeight;
    private int color = -1;
    private int generation;
    private @Nullable Identifier mappedSprite;

    public SpriteElement(Identifier sprite, int width, int height) {
        this(RenderPipelines.GUI_TEXTURED, sprite, width, height);
    }

    public SpriteElement(RenderPipeline renderPipeline, Identifier sprite, int width, int height) {
        this.renderPipeline = renderPipeline;
        this.sprite = sprite;
        this.oWidth = this.width = width;
        this.oHeight = this.height = height;
    }

    @Override
    public @Nullable Component getNarration() {
        return null;
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.tiledOrientation != null) {
            float tileAxisStep;
            TextureAtlasSprite textureAtlasSprite = graphics.guiSprites.getSprite(this.mappedSprite());
            Rect2f rect = this.floatingRect == null ? Rect2f.of(this) : this.floatingRect.copy();
            float axisLength = this.tiledOrientation.getAxisLength(rect);
            float axisPosition = this.tiledOrientation.getAxisPosition(rect);
            float crossAxisLength = this.tiledOrientation.getCrossAxisLength(rect);
            float crossAxisPosition = this.tiledOrientation.getCrossAxisPosition(rect);
            float f = tileAxisStep = this.tiledOrientation == Orientation.HORIZONTAL ? (float)this.oWidth : (float)this.oHeight;
            for (float tileAxisStart = 0.0f; tileAxisStart < axisLength; tileAxisStart += tileAxisStep) {
                float tileAxisEnd = Math.min(tileAxisStart + tileAxisStep, axisLength);
                float tileSize = tileAxisEnd - tileAxisStart;
                this.tiledOrientation.setPosition(rect, axisPosition + tileAxisStart, crossAxisPosition);
                this.tiledOrientation.setSize(rect, tileSize, crossAxisLength);
                float tileWidth = this.oWidth;
                float tileHeight = this.oHeight;
                if (this.tiledOrientation == Orientation.HORIZONTAL) {
                    tileWidth = tileSize;
                } else {
                    tileHeight = tileSize;
                }
                DisplayHelper.INSTANCE.blitSprite(graphics, this.renderPipeline, textureAtlasSprite, this.oWidth, this.oHeight, 0.0f, 0.0f, tileWidth, tileHeight, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), this.color);
            }
            return;
        }
        if (this.floatingRect == null) {
            IDisplayHelper.get().blitSprite(graphics, this.renderPipeline, this.mappedSprite(), this.oWidth, this.oHeight, 0, 0, this.getX(), this.getY(), this.width, this.height, this.color);
        } else {
            DisplayHelper.INSTANCE.blitSprite(graphics, this.renderPipeline, this.mappedSprite(), this.oWidth, this.oHeight, 0, 0, this.floatingRect.getX(), this.floatingRect.getY(), this.floatingRect.getWidth(), this.floatingRect.getHeight(), this.color);
        }
        if (IWailaConfig.get().general().isDebug() && this.floatingRect != null) {
            DisplayHelper.INSTANCE.drawBorder(graphics, new ScreenRectangle((int)this.floatingRect.getX(), (int)this.floatingRect.getY(), (int)this.floatingRect.getWidth(), (int)this.floatingRect.getHeight()), 1, -16733526, true);
        }
    }

    private Identifier mappedSprite() {
        if (this.mappedSprite == null || this.generation != IThemeHelper.get().generation()) {
            this.generation = IThemeHelper.get().generation();
            this.mappedSprite = IThemeHelper.get().theme().mapSprite(this.sprite);
        }
        return this.mappedSprite;
    }

    @Override
    public boolean canUseFloatingRect(GuiGraphics graphics) {
        TextureAtlasSprite textureAtlasSprite = graphics.guiSprites.getSprite(this.mappedSprite());
        GuiSpriteScaling scaling = textureAtlasSprite.contents().getAdditionalMetadata(GuiMetadataSection.TYPE).orElse(GuiMetadataSection.DEFAULT).scaling();
        return scaling instanceof GuiSpriteScaling.Stretch;
    }

    public void setColor(int color) {
        this.color = color;
    }
}

