/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.ClientPayloadContext;
import snownee.jade.util.JadeCodecs;

public record ServerHandshakePacket(Map<Identifier, Object> serverConfig, List<Block> shearableBlocks, List<Identifier> blockProviderIds, List<Identifier> entityProviderIds) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerHandshakePacket> TYPE = new CustomPacketPayload.Type(JadeIds.PACKET_SERVER_HANDSHAKE);
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerHandshakePacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)Identifier.STREAM_CODEC, JadeCodecs.PRIMITIVE_STREAM_CODEC), ServerHandshakePacket::serverConfig, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK).apply(ByteBufCodecs.list()), ServerHandshakePacket::shearableBlocks, (StreamCodec)ByteBufCodecs.list().apply(Identifier.STREAM_CODEC), ServerHandshakePacket::blockProviderIds, (StreamCodec)ByteBufCodecs.list().apply(Identifier.STREAM_CODEC), ServerHandshakePacket::entityProviderIds, ServerHandshakePacket::new);

    public static void handle(ServerHandshakePacket message, ClientPayloadContext context) {
        context.execute(() -> {
            ObjectDataCenter.serverConnected = true;
            HarvestToolProvider.INSTANCE.setShearableBlocks(message.shearableBlocks);
            WailaClientRegistration.instance().setServerConfig(message.serverConfig);
            WailaCommonRegistration.instance().blockDataProviders.remapIds(message.blockProviderIds);
            WailaCommonRegistration.instance().entityDataProviders.remapIds(message.entityProviderIds);
            Jade.LOGGER.info("Received config from the server: {}", message.serverConfig);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

