/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import org.jspecify.annotations.Nullable;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.util.CommonProxy;

public class JadeForgeUtils {
    private JadeForgeUtils() {
    }

    public static JadeFluidObject fromFluidResource(FluidResource resource, long amount) {
        return JadeFluidObject.of(resource.getFluid(), amount, resource.getComponentsPatch());
    }

    public static List<ViewGroup<FluidView.Data>> fromFluidHandler(ResourceHandler<FluidResource> storage) {
        int maxTanks;
        if (storage.size() == 0) {
            return List.of();
        }
        FluidCollectingResult result = JadeForgeUtils.fromFluidHandlerStream(storage);
        if (result.tanks == 0) {
            return List.of();
        }
        ArrayList list = Lists.newArrayList();
        int n = maxTanks = result.emptyTanks == 0 ? 5 : 4;
        if (result.tanks - result.emptyTanks <= maxTanks) {
            list.addAll(result.stream.toList());
        } else {
            result.stream.takeWhile(tag -> list.size() <= maxTanks).forEach(tuple1 -> {
                for (Tuple tuple2 : list) {
                    if (!JadeFluidObject.isSameFluidSameComponents((JadeFluidObject)tuple1.getA(), (JadeFluidObject)tuple2.getA())) continue;
                    return;
                }
                list.add(tuple1);
            });
        }
        int remaining = result.tanks - result.emptyTanks - list.size();
        if (result.emptyTanks > 0) {
            list.add(new Tuple((Object)JadeFluidObject.empty(), (Object)result.emptyCapacity));
        }
        ViewGroup<FluidView.Data> group = new ViewGroup<FluidView.Data>(list.stream().map(tuple -> new FluidView.Data((JadeFluidObject)tuple.getA(), (long)((Long)tuple.getB()))).toList());
        if (remaining > 0) {
            group.getExtraData().putInt("+", remaining);
        }
        return List.of(group);
    }

    public static FluidCollectingResult fromFluidHandlerStream(ResourceHandler<FluidResource> fluidHandler) {
        FluidCollectingResult result = new FluidCollectingResult();
        for (int i2 = 0; i2 < fluidHandler.size(); ++i2) {
            if (fluidHandler.getCapacityAsLong(i2, (Resource)FluidResource.EMPTY) <= 0L) continue;
            ++result.tanks;
            if (!((FluidResource)fluidHandler.getResource(i2)).isEmpty()) continue;
            ++result.emptyTanks;
        }
        result.stream = result.tanks == 0 ? Stream.empty() : IntStream.range(0, fluidHandler.size()).mapToObj(i -> {
            long capacity = fluidHandler.getCapacityAsLong(i, (Resource)FluidResource.EMPTY);
            if (capacity <= 0L) {
                return null;
            }
            FluidResource resource = (FluidResource)fluidHandler.getResource(i);
            if (resource.isEmpty()) {
                result.emptyCapacity = LongMath.saturatedAdd((long)result.emptyCapacity, (long)capacity);
                return null;
            }
            return new Tuple((Object)JadeForgeUtils.fromFluidResource(resource, fluidHandler.getAmountAsLong(i)), (Object)capacity);
        }).filter(Objects::nonNull);
        return result;
    }

    public static ItemIterator<? extends ResourceHandler<ItemResource>> fromItemHandler(ResourceHandler<ItemResource> storage, int fromIndex) {
        return JadeForgeUtils.fromItemHandler(storage, fromIndex, CommonProxy::findItemHandler);
    }

    public static ItemIterator<? extends ResourceHandler<ItemResource>> fromItemHandler(ResourceHandler<ItemResource> storage, int fromIndex, Function<Accessor<?>, @Nullable ResourceHandler<ItemResource>> containerFinder) {
        return new ItemIterator.SlottedItemIterator<ResourceHandler<ItemResource>>(containerFinder, fromIndex){

            @Override
            protected int getSlotCount(ResourceHandler<ItemResource> container) {
                return container.size();
            }

            @Override
            protected ItemStack getItemInSlot(ResourceHandler<ItemResource> container, int slot) {
                return ((ItemResource)container.getResource(slot)).toStack();
            }
        };
    }

    public static class FluidCollectingResult {
        public Stream<Tuple<JadeFluidObject, Long>> stream = Stream.empty();
        public long emptyCapacity;
        public int tanks;
        public int emptyTanks;
    }
}

