/*
 * Decompiled with CFR 0.152.
 */
package net.cynwale.soundblocks;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.cynwale.soundblocks.SoundBlocks;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public class CustomSoundManager {
    public static final Path CUSTOM_SOUNDS_DIR = FabricLoader.getInstance().getConfigDir().resolve("sound-blocks/custom_sounds");
    public static final Map<String, Path> SOUND_FILE_MAP = new HashMap<String, Path>();
    public static final List<String> SOUND_IDS = new ArrayList<String>();

    public static void init() {
        try {
            if (!Files.exists(CUSTOM_SOUNDS_DIR, new LinkOption[0])) {
                Files.createDirectories(CUSTOM_SOUNDS_DIR, new FileAttribute[0]);
            }
            try (Stream<Path> paths = Files.walk(CUSTOM_SOUNDS_DIR, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".ogg")).forEach(path -> {
                    String filename = path.getFileName().toString();
                    String id = filename.substring(0, filename.length() - 4);
                    if (!SOUND_FILE_MAP.containsKey(id = id.toLowerCase().replaceAll("[^a-z0-9_]", "_"))) {
                        CustomSoundManager.registerCustomSound(id);
                        SOUND_IDS.add(id);
                        SOUND_FILE_MAP.put(id, (Path)path);
                    }
                });
            }
        }
        catch (IOException e) {
            SoundBlocks.LOGGER.error("Failed to load custom sounds", (Throwable)e);
        }
    }

    private static void registerCustomSound(String name) {
        class_2960 id = new class_2960("sound-blocks", name);
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)class_3414.method_47908((class_2960)id));
        SoundBlocks.LOGGER.info("Registered custom sound: " + String.valueOf(id));
    }
}

