/*
 * Decompiled with CFR 0.152.
 */
package net.cynwale.soundblocks;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.cynwale.soundblocks.CustomSoundManager;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import org.jetbrains.annotations.Nullable;

public class CustomSoundResourcePack
implements class_3262 {
    private static final String NAMESPACE = "sound-blocks";

    @Nullable
    public class_7367<InputStream> method_14410(String ... elements) {
        return null;
    }

    @Nullable
    public class_7367<InputStream> method_14405(class_3264 type, class_2960 location) {
        String soundId;
        Path filePath;
        if (type != class_3264.field_14188) {
            return null;
        }
        if (!location.method_12836().equals(NAMESPACE)) {
            return null;
        }
        String path = location.method_12832();
        if (path.startsWith("sounds/") && path.endsWith(".ogg") && (filePath = CustomSoundManager.SOUND_FILE_MAP.get(soundId = path.substring(7, path.length() - 4))) != null && Files.exists(filePath, new LinkOption[0])) {
            return () -> new FileInputStream(filePath.toFile());
        }
        if (path.equals("sounds.json")) {
            return this::generateSoundsJson;
        }
        return null;
    }

    private InputStream generateSoundsJson() {
        JsonObject root = new JsonObject();
        for (String soundId : CustomSoundManager.SOUND_IDS) {
            JsonObject entry = new JsonObject();
            entry.addProperty("category", "block");
            JsonArray sounds = new JsonArray();
            JsonObject soundObj = new JsonObject();
            soundObj.addProperty("name", "sound-blocks:" + soundId);
            soundObj.addProperty("stream", Boolean.valueOf(true));
            sounds.add((JsonElement)soundObj);
            entry.add("sounds", (JsonElement)sounds);
            root.add(soundId, (JsonElement)entry);
        }
        return new ByteArrayInputStream(root.toString().getBytes(StandardCharsets.UTF_8));
    }

    public void method_14408(class_3264 type, String namespace, String path, class_3262.class_7664 resourceOutput) {
        if (type == class_3264.field_14188 && namespace.equals(NAMESPACE) && path.equals("sounds")) {
            for (String id : CustomSoundManager.SOUND_IDS) {
                class_2960 loc = new class_2960(NAMESPACE, "sounds/" + id + ".ogg");
                resourceOutput.accept((Object)loc, this.method_14405(type, loc));
            }
        }
    }

    public Set<String> method_14406(class_3264 type) {
        HashSet<String> set = new HashSet<String>();
        set.add(NAMESPACE);
        return set;
    }

    @Nullable
    public <T> T method_14407(class_3270<T> deserializer) {
        if (deserializer == class_3272.field_14202) {
            return (T)new class_3272((class_2561)class_2561.method_43470((String)"Sound Blocks Custom Audio"), 15);
        }
        return null;
    }

    public String method_14409() {
        return "SoundBlocksCustomSounds";
    }

    public void close() {
    }

    public class_2561 getTitle() {
        return class_2561.method_43470((String)"Sound Blocks Custom Audio");
    }

    public boolean isFixed() {
        return true;
    }
}

