/*
 * Decompiled with CFR 0.152.
 */
package net.cynwale.soundblocks;

import net.cynwale.soundblocks.ModBlocks;
import net.cynwale.soundblocks.SoundBlockEntity;
import net.cynwale.soundblocks.SoundBlocksNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;

public class SoundBlock
extends class_2237 {
    public static final class_2746 POWERED = class_2741.field_12484;

    public SoundBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_1309 entity;
        class_3727 entityContext;
        class_1297 class_12972;
        if (context instanceof class_3727 && (class_12972 = (entityContext = (class_3727)context).method_32480()) instanceof class_1309 && ((entity = (class_1309)class_12972).method_6047().method_31574(ModBlocks.SOUND_BLOCK.method_8389()) || entity.method_6079().method_31574(ModBlocks.SOUND_BLOCK.method_8389()))) {
            return class_259.method_1077();
        }
        return class_259.method_1073();
    }

    public boolean method_9579(class_2680 state, class_1922 level, class_2338 pos) {
        return true;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SoundBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (level.field_9236) {
            return SoundBlock.method_31618(type, ModBlocks.SOUND_BLOCK_ENTITY, SoundBlockEntity::clientTick);
        }
        return null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED});
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            this.stopBlockSound(level, pos);
            super.method_9536(state, level, pos, newState, isMoving);
        }
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
        if (level.field_9236) {
            return;
        }
        boolean isReceivingPower = level.method_49803(pos);
        boolean isPoweredByGui = false;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof SoundBlockEntity) {
            SoundBlockEntity entity = (SoundBlockEntity)class_25862;
            isPoweredByGui = entity.isPoweredByGui();
        }
        boolean isEffectivePower = isReceivingPower || isPoweredByGui;
        boolean isAlreadyPowered = (Boolean)state.method_11654((class_2769)POWERED);
        if (isEffectivePower && !isAlreadyPowered) {
            this.playBlockSound(level, pos);
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(true)), 3);
        } else if (!isEffectivePower && isAlreadyPowered) {
            this.stopBlockSound(level, pos);
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public void updateBlockVolume(class_1937 level, class_2338 pos, float volume) {
        if (level.field_9236) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeFloat(volume);
        this.sendToNearby(level, pos, SoundBlocksNetworking.SYNC_LOOP_VOLUME, buf);
    }

    public void updateBlockPitch(class_1937 level, class_2338 pos, float pitch) {
        if (level.field_9236) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeFloat(pitch);
        this.sendToNearby(level, pos, SoundBlocksNetworking.SYNC_LOOP_PITCH, buf);
    }

    public void updateBlockRange(class_1937 level, class_2338 pos, int range) {
        if (level.field_9236) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeInt(range);
        this.sendToNearby(level, pos, SoundBlocksNetworking.SYNC_LOOP_RANGE, buf);
    }

    public void updateBlockDelay(class_1937 level, class_2338 pos, int delay) {
        if (level.field_9236) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        buf.writeInt(delay);
        this.sendToNearby(level, pos, SoundBlocksNetworking.SYNC_LOOP_DELAY, buf);
    }

    private void sendToNearby(class_1937 level, class_2338 pos, class_2960 packetId, class_2540 buf) {
        ((class_3218)level).method_14178().field_17254.method_17210(new class_1923(pos), false).forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)packetId, (class_2540)buf));
    }

    public void playBlockSound(class_1937 level, class_2338 pos) {
        if (level.field_9236) {
            return;
        }
        class_2586 entity = level.method_8321(pos);
        if (entity instanceof SoundBlockEntity) {
            SoundBlockEntity soundEntity = (SoundBlockEntity)entity;
            String soundId = soundEntity.getSoundId();
            float volume = soundEntity.getVolume();
            float pitch = soundEntity.getPitch();
            int range = soundEntity.getRange();
            int delay = soundEntity.getRandomDelay();
            boolean isLooping = soundEntity.isLooping();
            class_2540 buf = PacketByteBufs.create();
            buf.method_10807(pos);
            buf.method_10814(soundId);
            buf.writeFloat(volume);
            buf.writeFloat(pitch);
            buf.writeInt(range);
            buf.writeInt(delay);
            buf.writeBoolean(isLooping);
            this.sendToNearby(level, pos, SoundBlocksNetworking.SYNC_LOOP_START, buf);
        }
    }

    public void stopBlockSound(class_1937 level, class_2338 pos) {
        if (level.field_9236) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(pos);
        this.sendToNearby(level, pos, SoundBlocksNetworking.SYNC_LOOP_STOP, buf);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!player.method_5998(hand).method_31574(ModBlocks.SOUND_BLOCK.method_8389())) {
            return class_1269.field_5811;
        }
        if (!world.field_9236 && hand == class_1268.field_5808) {
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof SoundBlockEntity) {
                SoundBlockEntity entity = (SoundBlockEntity)class_25862;
                class_2540 buf = PacketByteBufs.create();
                buf.method_10807(pos);
                buf.method_10814(entity.getSoundId());
                buf.writeBoolean(entity.isLooping());
                buf.writeBoolean(entity.isPoweredByGui());
                buf.writeFloat(entity.getVolume());
                buf.writeFloat(entity.getPitch());
                buf.writeInt(entity.getRange());
                buf.writeInt(entity.getRandomDelay());
                ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)SoundBlocksNetworking.OPEN_CONFIG_SCREEN_ID, (class_2540)buf);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }
}

