/*
 * Decompiled with CFR 0.152.
 */
package net.cynwale.soundblocks;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.cynwale.soundblocks.SoundBlockLoopSound;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1113;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;

public class SoundBlockClientManager {
    private static final Map<class_2338, LoopController> CONTROLLERS = new HashMap<class_2338, LoopController>();

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> SoundBlockClientManager.tick());
    }

    private static void tick() {
        CONTROLLERS.forEach((pos, ctrl) -> {
            boolean isPlaying;
            boolean bl = isPlaying = ctrl.activeSound != null && !ctrl.activeSound.method_4793();
            if (!isPlaying && ctrl.shouldLoop) {
                if (ctrl.maxDelaySeconds == 0) {
                    SoundBlockClientManager.playSound(pos, ctrl, true);
                } else if (ctrl.ticksUntilNextPlay > 0) {
                    --ctrl.ticksUntilNextPlay;
                } else {
                    int delayTicks;
                    SoundBlockClientManager.playSound(pos, ctrl, false);
                    ctrl.ticksUntilNextPlay = delayTicks = ctrl.random.nextInt(ctrl.maxDelaySeconds * 20 + 1);
                }
            }
        });
        CONTROLLERS.entrySet().removeIf(entry -> {
            LoopController ctrl = (LoopController)entry.getValue();
            boolean isPlaying = ctrl.activeSound != null && !ctrl.activeSound.method_4793();
            return !isPlaying && !ctrl.shouldLoop;
        });
    }

    private static void playSound(class_2338 pos, LoopController ctrl, boolean engineLoop) {
        try {
            class_2960 location = new class_2960(ctrl.soundId);
            class_3414 soundEvent = class_3414.method_47908((class_2960)location);
            ctrl.activeSound = new SoundBlockLoopSound(soundEvent, pos);
            ctrl.activeSound.setBaseVolume(ctrl.volume);
            ctrl.activeSound.setPitch(ctrl.pitch);
            ctrl.activeSound.setRange(ctrl.range);
            ctrl.activeSound.setLooping(engineLoop);
            class_310.method_1551().method_1483().method_4873((class_1113)ctrl.activeSound);
        }
        catch (Exception e) {
            System.out.println("Failed to play sound: " + ctrl.soundId);
        }
    }

    public static void startLoop(class_2338 pos, String soundId, float volume, float pitch, int range, int delay, boolean isLooping) {
        if (CONTROLLERS.containsKey(pos)) {
            LoopController ctrl = CONTROLLERS.get(pos);
            ctrl.volume = volume;
            ctrl.pitch = pitch;
            ctrl.range = range;
            ctrl.maxDelaySeconds = delay;
            ctrl.shouldLoop = isLooping;
            return;
        }
        LoopController newCtrl = new LoopController(soundId, volume, pitch, range, delay, isLooping);
        CONTROLLERS.put(pos, newCtrl);
        boolean engineLoop = isLooping && delay == 0;
        SoundBlockClientManager.playSound(pos, newCtrl, engineLoop);
    }

    public static void stopLoop(class_2338 pos) {
        if (CONTROLLERS.containsKey(pos)) {
            LoopController ctrl = CONTROLLERS.get(pos);
            if (ctrl.activeSound != null) {
                ctrl.activeSound.setStopped(true);
            }
            CONTROLLERS.remove(pos);
        }
    }

    public static void updateVolume(class_2338 pos, float volume) {
        if (CONTROLLERS.containsKey(pos)) {
            LoopController ctrl = CONTROLLERS.get(pos);
            ctrl.volume = volume;
            if (ctrl.activeSound != null) {
                ctrl.activeSound.setBaseVolume(volume);
            }
        }
    }

    public static void updatePitch(class_2338 pos, float pitch) {
        if (CONTROLLERS.containsKey(pos)) {
            LoopController ctrl = CONTROLLERS.get(pos);
            ctrl.pitch = pitch;
            if (ctrl.activeSound != null) {
                ctrl.activeSound.setPitch(pitch);
            }
        }
    }

    public static void updateRange(class_2338 pos, int range) {
        if (CONTROLLERS.containsKey(pos)) {
            LoopController ctrl = CONTROLLERS.get(pos);
            ctrl.range = range;
            if (ctrl.activeSound != null) {
                ctrl.activeSound.setRange(range);
            }
        }
    }

    public static void updateDelay(class_2338 pos, int delay) {
        if (CONTROLLERS.containsKey(pos)) {
            LoopController ctrl = CONTROLLERS.get(pos);
            boolean wasContinuous = ctrl.maxDelaySeconds == 0;
            boolean nowContinuous = delay == 0;
            ctrl.maxDelaySeconds = delay;
            if (wasContinuous != nowContinuous && ctrl.activeSound != null) {
                ctrl.activeSound.setStopped(true);
            }
        }
    }

    private static class LoopController {
        SoundBlockLoopSound activeSound;
        String soundId;
        float volume;
        float pitch;
        int range;
        int maxDelaySeconds;
        boolean shouldLoop;
        int ticksUntilNextPlay;
        final Random random = new Random();

        public LoopController(String soundId, float volume, float pitch, int range, int maxDelaySeconds, boolean shouldLoop) {
            this.soundId = soundId;
            this.volume = volume;
            this.pitch = pitch;
            this.range = range;
            this.maxDelaySeconds = maxDelaySeconds;
            this.shouldLoop = shouldLoop;
            this.ticksUntilNextPlay = 0;
        }
    }
}

