/*
 * Decompiled with CFR 0.152.
 */
package net.cynwale.soundblocks;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import net.cynwale.soundblocks.SoundBlockClothLibrary;
import net.cynwale.soundblocks.SoundBlockEntity;
import net.cynwale.soundblocks.SoundBlocksNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7923;

public class SoundBlockConfigScreen {
    private static List<String> CACHED_SOUNDS = null;

    public static class_437 create(SoundBlockEntity entity) {
        String currentShortName;
        List<String> shortNames;
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(class_310.method_1551().field_1755).setTitle((class_2561)class_2561.method_43470((String)"Sound Block Configuration"));
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"General"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        if (CACHED_SOUNDS == null) {
            CACHED_SOUNDS = new ArrayList<String>();
            for (class_2960 id : class_7923.field_41172.method_10235()) {
                if (!id.method_12836().equals("sound-blocks")) continue;
                CACHED_SOUNDS.add(id.toString());
            }
            CACHED_SOUNDS.sort(String::compareTo);
            if (CACHED_SOUNDS.isEmpty()) {
                CACHED_SOUNDS.add("sound-blocks:electric_fan");
            }
        }
        if (!(shortNames = CACHED_SOUNDS.stream().map(SoundBlockConfigScreen::formatSoundId).toList()).contains(currentShortName = SoundBlockConfigScreen.formatSoundId(entity.getSoundId()))) {
            currentShortName = shortNames.get(0);
        }
        IntegerSliderEntry delayEntry = entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Random Delay"), entity.getRandomDelay(), 0, 60).setDefaultValue(0).setTextGetter(val -> class_2561.method_43470((String)(val == 0 ? "None (Continuous)" : "Max " + val + "s"))).setTooltip(new class_2561[]{class_2561.method_43470((String)"Adds a random pause between loops.\nOnly works if Looping Mode is ON.")}).setSaveConsumer(newValue -> {
            entity.setRandomDelay((int)newValue);
            SoundBlockConfigScreen.saveData(entity);
        }).build();
        BooleanToggleBuilder loopingBuilder = entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Looping Mode"), entity.isLooping()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"If true, sound loops while powered.")}).setSaveConsumer(newValue -> {
            entity.setLooping((boolean)newValue);
            SoundBlockConfigScreen.saveData(entity);
        });
        SoundBlockClothLibrary.link(loopingBuilder, delayEntry);
        general.addEntry((AbstractConfigListEntry)loopingBuilder.build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)"Play Sound (Manual)"), entity.isPoweredByGui()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Turn ON to power the block and play sound immediately.")}).setSaveConsumer(newValue -> {
            entity.setPoweredByGui((boolean)newValue);
            SoundBlockConfigScreen.saveData(entity);
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Volume"), (int)(entity.getVolume() * 100.0f), 0, 200).setDefaultValue(100).setTextGetter(val -> class_2561.method_43470((String)(val + "%"))).setSaveConsumer(newValue -> {
            entity.setVolume((float)newValue.intValue() / 100.0f);
            SoundBlockConfigScreen.saveData(entity);
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Pitch"), (int)(entity.getPitch() * 100.0f), 10, 200).setDefaultValue(100).setTextGetter(val -> class_2561.method_43470((String)(val + "%"))).setSaveConsumer(newValue -> {
            int safeValue = Math.max(10, newValue);
            entity.setPitch((float)safeValue / 100.0f);
            SoundBlockConfigScreen.saveData(entity);
        }).build());
        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)class_2561.method_43470((String)"Range"), entity.getRange(), 1, 64).setDefaultValue(16).setTextGetter(val -> class_2561.method_43470((String)(val + " Blocks"))).setSaveConsumer(newValue -> {
            entity.setRange((int)newValue);
            SoundBlockConfigScreen.saveData(entity);
        }).build());
        general.addEntry((AbstractConfigListEntry)delayEntry);
        general.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((class_2561)class_2561.method_43470((String)"Sound Selection"), currentShortName).setSelections(shortNames).setDefaultValue((Object)shortNames.get(0)).setTooltip(new class_2561[]{class_2561.method_43470((String)"Select a custom sound from the list")}).setSaveConsumer(newValue -> {
            String fullId = "sound-blocks:" + newValue;
            entity.setSoundId(fullId);
            SoundBlockConfigScreen.saveData(entity);
        }).setSuggestionMode(true).build());
        return builder.build();
    }

    private static String formatSoundId(String fullId) {
        if (fullId.startsWith("sound-blocks:")) {
            return fullId.replace("sound-blocks:", "");
        }
        return fullId;
    }

    private static void saveData(SoundBlockEntity entity) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(entity.method_11016());
        buf.method_10814(entity.getSoundId());
        buf.writeBoolean(entity.isLooping());
        buf.writeBoolean(entity.isPoweredByGui());
        buf.writeFloat(entity.getVolume());
        buf.writeFloat(entity.getPitch());
        buf.writeInt(entity.getRange());
        buf.writeInt(entity.getRandomDelay());
        ClientPlayNetworking.send((class_2960)SoundBlocksNetworking.SOUND_BLOCK_SYNC_ID, (class_2540)buf);
    }
}

