/*
 * Decompiled with CFR 0.152.
 */
package net.cynwale.soundblocks;

import net.cynwale.soundblocks.SoundBlock;
import net.cynwale.soundblocks.SoundBlockClientManager;
import net.cynwale.soundblocks.SoundBlockEntity;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class SoundBlocksNetworking {
    public static final class_2960 SOUND_BLOCK_SYNC_ID = new class_2960("sound-blocks", "sound_block_sync");
    public static final class_2960 OPEN_CONFIG_SCREEN_ID = new class_2960("sound-blocks", "open_config_screen");
    public static final class_2960 SYNC_LOOP_START = new class_2960("sound-blocks", "sync_loop_start");
    public static final class_2960 SYNC_LOOP_STOP = new class_2960("sound-blocks", "sync_loop_stop");
    public static final class_2960 SYNC_LOOP_VOLUME = new class_2960("sound-blocks", "sync_loop_volume");
    public static final class_2960 SYNC_LOOP_PITCH = new class_2960("sound-blocks", "sync_loop_pitch");
    public static final class_2960 SYNC_LOOP_RANGE = new class_2960("sound-blocks", "sync_loop_range");
    public static final class_2960 SYNC_LOOP_DELAY = new class_2960("sound-blocks", "sync_loop_delay");

    public static void registerS2CPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_LOOP_START, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            String soundId = buf.method_19772();
            float volume = buf.readFloat();
            float pitch = buf.readFloat();
            int range = buf.readInt();
            int delay = buf.readInt();
            boolean isLooping = buf.readBoolean();
            client.execute(() -> SoundBlockClientManager.startLoop(pos, soundId, volume, pitch, range, delay, isLooping));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_LOOP_STOP, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            client.execute(() -> SoundBlockClientManager.stopLoop(pos));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_LOOP_VOLUME, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            float volume = buf.readFloat();
            client.execute(() -> SoundBlockClientManager.updateVolume(pos, volume));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_LOOP_PITCH, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            float pitch = buf.readFloat();
            client.execute(() -> SoundBlockClientManager.updatePitch(pos, pitch));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_LOOP_RANGE, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int range = buf.readInt();
            client.execute(() -> SoundBlockClientManager.updateRange(pos, range));
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SYNC_LOOP_DELAY, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int delay = buf.readInt();
            client.execute(() -> SoundBlockClientManager.updateDelay(pos, delay));
        });
    }

    public static void registerC2SPackets() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SOUND_BLOCK_SYNC_ID, (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            String newSoundId = buf.method_19772();
            boolean newLooping = buf.readBoolean();
            boolean newPoweredByGui = buf.readBoolean();
            float newVolume = buf.readFloat();
            float newPitch = buf.readFloat();
            int newRange = buf.readInt();
            int newDelay = buf.readInt();
            server.execute(() -> {
                class_2586 patt0$temp;
                if (player.method_37908().method_8477(pos) && player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) < 64.0 && (patt0$temp = player.method_37908().method_8321(pos)) instanceof SoundBlockEntity) {
                    SoundBlockEntity soundBlockEntity = (SoundBlockEntity)patt0$temp;
                    soundBlockEntity.setSoundId(newSoundId);
                    soundBlockEntity.setLooping(newLooping);
                    soundBlockEntity.setPoweredByGui(newPoweredByGui);
                    soundBlockEntity.setVolume(newVolume);
                    soundBlockEntity.setPitch(newPitch);
                    soundBlockEntity.setRange(newRange);
                    soundBlockEntity.setRandomDelay(newDelay);
                    class_2680 currentState = player.method_37908().method_8320(pos);
                    class_2248 patt1$temp = currentState.method_26204();
                    if (patt1$temp instanceof SoundBlock) {
                        SoundBlock soundBlock = (SoundBlock)patt1$temp;
                        boolean isRedstonePowered = player.method_37908().method_49803(pos);
                        boolean shouldBePowered = newPoweredByGui || isRedstonePowered;
                        boolean isCurrentlyPowered = (Boolean)currentState.method_11654((class_2769)SoundBlock.POWERED);
                        if (isCurrentlyPowered) {
                            soundBlock.updateBlockVolume(player.method_37908(), pos, newVolume);
                            soundBlock.updateBlockPitch(player.method_37908(), pos, newPitch);
                            soundBlock.updateBlockRange(player.method_37908(), pos, newRange);
                            soundBlock.updateBlockDelay(player.method_37908(), pos, newDelay);
                        }
                        if (shouldBePowered != isCurrentlyPowered) {
                            if (shouldBePowered) {
                                soundBlock.playBlockSound(player.method_37908(), pos);
                                player.method_37908().method_8652(pos, (class_2680)currentState.method_11657((class_2769)SoundBlock.POWERED, (Comparable)Boolean.valueOf(true)), 3);
                            } else {
                                soundBlock.stopBlockSound(player.method_37908(), pos);
                                player.method_37908().method_8652(pos, (class_2680)currentState.method_11657((class_2769)SoundBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
                            }
                        } else if (isCurrentlyPowered) {
                            soundBlock.stopBlockSound(player.method_37908(), pos);
                            soundBlock.playBlockSound(player.method_37908(), pos);
                        }
                    }
                }
            });
        });
    }
}

