/*
 * Decompiled with CFR 0.152.
 */
package org.doraji.oldFishingRod;

import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.doraji.oldFishingRod.OldFishingRod;

public class FishingRodListener
implements Listener {
    private final OldFishingRod plugin;

    public FishingRodListener(OldFishingRod plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onProjectileLaunch(ProjectileLaunchEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof FishHook)) {
            return;
        }
        final FishHook hook = (FishHook)projectile;
        ProjectileSource projectileSource = hook.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        final Player player = (Player)projectileSource;
        Vector velocity = hook.getVelocity();
        hook.setVelocity(velocity.multiply(this.plugin.hookSpeedMultiplier));
        new BukkitRunnable(this){
            private int ticks = 0;
            private final int maxTicks = 60;

            public void run() {
                if (hook.isDead() || !hook.isValid() || this.ticks >= 60) {
                    this.cancel();
                    return;
                }
                if (hook.getState() == FishHook.HookState.HOOKED_ENTITY) {
                    Entity hookedEntity = hook.getHookedEntity();
                    if (hookedEntity != null && !hookedEntity.isDead() && hookedEntity instanceof LivingEntity) {
                        LivingEntity livingHookedEntity = (LivingEntity)hookedEntity;
                        livingHookedEntity.damage(0.01, (Entity)player);
                    }
                    this.cancel();
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerReelIn(PlayerFishEvent event) {
        final Entity caughtEntity = event.getCaught();
        if (caughtEntity == null) {
            return;
        }
        if (event.getState() == PlayerFishEvent.State.CAUGHT_ENTITY) {
            new BukkitRunnable(this){

                public void run() {
                    Objects.requireNonNull(caughtEntity).setVelocity(new Vector(0, 0, 0));
                }
            }.runTaskLater((Plugin)this.plugin, 1L);
        }
    }
}

