/*
 * Decompiled with CFR 0.152.
 */
package org.doraji.oldFishingRod;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.doraji.oldFishingRod.OldFishingRod;

public class NoCoolSwordListener
implements Listener {
    private final OldFishingRod plugin;
    private static final double FAST_ATTACK_SPEED = 8.0;
    private static final double DEFAULT_ATTACK_SPEED = 4.0;
    private static final long BOOST_DURATION_TICKS = 10L;
    private static final EnumSet<Material> SWORD_TYPES = EnumSet.of(Material.WOODEN_SWORD, new Material[]{Material.STONE_SWORD, Material.IRON_SWORD, Material.GOLDEN_SWORD, Material.DIAMOND_SWORD, Material.NETHERITE_SWORD});
    private final Map<UUID, BukkitTask> attackSpeedTasks = new HashMap<UUID, BukkitTask>();

    public NoCoolSwordListener(OldFishingRod plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.cancelAndReset(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.resetAttackSpeed(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        this.runTaskLater(() -> this.checkHandAndReset(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.runTaskLater(() -> this.checkHandAndReset(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onItemHeldChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        ItemStack newItem = player.getInventory().getItem(event.getNewSlot());
        if (this.isSword(newItem)) {
            this.triggerBoost(player);
        } else {
            this.cancelAndReset(player);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        this.runTaskLater(() -> this.checkHandAndReset(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerItemBreak(PlayerItemBreakEvent event) {
        this.runTaskLater(() -> this.checkHandAndReset(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        this.runTaskLater(() -> this.checkHandAndReset(event.getPlayer()));
    }

    private void triggerBoost(final Player player) {
        final UUID uuid = player.getUniqueId();
        if (this.attackSpeedTasks.containsKey(uuid)) {
            this.attackSpeedTasks.get(uuid).cancel();
        }
        this.setAttackSpeed(player, 8.0);
        BukkitTask resetTask = new BukkitRunnable(){

            public void run() {
                NoCoolSwordListener.this.setAttackSpeed(player, 4.0);
                NoCoolSwordListener.this.attackSpeedTasks.remove(uuid);
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
        this.attackSpeedTasks.put(uuid, resetTask);
    }

    private void checkHandAndReset(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        ItemStack mainHandItem = player.getInventory().getItemInMainHand();
        if (!this.isSword(mainHandItem)) {
            this.cancelAndReset(player);
        }
    }

    private void cancelAndReset(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.attackSpeedTasks.containsKey(uuid)) {
            this.attackSpeedTasks.get(uuid).cancel();
            this.attackSpeedTasks.remove(uuid);
        }
        this.resetAttackSpeed(player);
    }

    private void setAttackSpeed(Player player, double speed) {
        AttributeInstance attribute = player.getAttribute(Attribute.ATTACK_SPEED);
        if (attribute != null) {
            attribute.setBaseValue(speed);
        }
    }

    private void resetAttackSpeed(Player player) {
        this.setAttackSpeed(player, 4.0);
    }

    private boolean isSword(ItemStack item) {
        return item != null && SWORD_TYPES.contains(item.getType());
    }

    private void runTaskLater(final Runnable runnable) {
        new BukkitRunnable(this){

            public void run() {
                runnable.run();
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
    }
}

