//Made by FSang18
StartupEvents.registry('palladium:condition_serializer', (event) => {
    event.create('fsang:armor_durability')
        .addProperty('slot', 'string', 'chest', 'Armor slot to check (head, chest, legs, feet)')
        .addProperty('min_percent', 'float', 0.0, 'Minimum percentage durability (0.0 to 1.0)')
        .addProperty('max_percent', 'float', 1.0, 'Maximum percentage durability (0.0 to 1.0)')
        .test((entity, props) => {
            const slot = props.get('slot').toLowerCase();
            const min = props.get('min_percent');
            const max = props.get('max_percent');

            let item;
            switch (slot) {
                case 'head': item = entity.headArmorItem; break;
                case 'chest': item = entity.chestArmorItem; break;
                case 'legs': item = entity.legsArmorItem; break;
                case 'feet': item = entity.feetArmorItem; break;
                default: return false; // Invalid slot
            }

            if (item && !item.isEmpty() && item.isDamageableItem()) {
                let damage = item.damageValue;
                let maxDamage = item.maxDamage;

                if (maxDamage > 0) {
                    let percentRemaining = 1 - (damage / maxDamage);
                    return percentRemaining >= min && percentRemaining <= max;
                }
            }

            return false;
        });
});