StartupEvents.registry('palladium:abilities', (event) => {
    event.create('fsang:store_armor')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .documentationDescription('Store your worn armor or held item.')
        .addProperty('namespace', 'string', 'fsang', 'Namespace for your storage location')
        .addProperty('identity', 'string', 'store', 'Additional name for your storage location')
        .addProperty('target', 'string', 'all', 'Storage target: all, mainhand, or offhand')
        .lastTick((entity, entry, holder, enabled) => {
            if (!enabled || entity.isDeadOrDying()) return;

            const target = entry.getPropertyByName('target');
            const namespace = entry.getPropertyByName('namespace');
            const name = entity.getGameProfile().getName();

            if (target === 'all') {
                let armorSlots = ['head', 'chest', 'legs', 'feet'];
                let hasArmor = false;

                armorSlots.forEach(slot => {
                    let item = entity[slot + 'ArmorItem'];
                    if (item && item.id !== 'minecraft:air') {
                        hasArmor = true;
                        entity.persistentData.put(slot + namespace, item);
                        entity.server.runCommandSilent(`item replace entity ${name} armor.${slot} with air`);
                    }
                });

                if (hasArmor) {
                    entity.persistentData.putBoolean('hasStoredArmor', true);
                }
            } else if (target === 'mainhand') {
                let main = entity.mainHandItem;
                if (main && main.id !== 'minecraft:air') {
                    entity.persistentData.put(namespace, main);
                    entity.persistentData.putInt(namespace + '_mainhand_count', main.count ?? 1);
                    entity.server.runCommandSilent(`item replace entity ${name} weapon.mainhand with air`);
                    entity.persistentData.putBoolean('hasStoredMainhand', true);
                }
            } else if (target === 'offhand') {
                let off = entity.offhandItem;
                if (off && off.id !== 'minecraft:air') {
                    entity.persistentData.put(namespace, off);
                    entity.persistentData.putInt(namespace + '_offhand_count', off.count ?? 1);
                    entity.server.runCommandSilent(`item replace entity ${name} weapon.offhand with air`);
                    entity.persistentData.putBoolean('hasStoredOffhand', true);
                }
            }
        });

    event.create('fsang:get_armor')
        .icon(palladium.createItemIcon('minecraft:iron_chestplate'))
        .documentationDescription('Retrieve stored armor or held item.')
        .addProperty('namespace', 'string', 'fsang', 'Namespace for your storage location')
        .addProperty('identity', 'string', 'store', 'Additional name for your storage location')
        .addProperty('target', 'string', 'all', 'Storage target: all, mainhand, or offhand')
        .firstTick((entity, entry, holder, enabled) => {
            if (!enabled || entity.isDeadOrDying()) return;

            const target = entry.getPropertyByName('target');
            const namespace = entry.getPropertyByName('namespace');
            const name = entity.getGameProfile().getName();

            if (target === 'all' && entity.persistentData.getBoolean('hasStoredArmor')) {
                let armorSlots = ['head', 'chest', 'legs', 'feet'];

                armorSlots.forEach(slot => {
                    let stored = entity.persistentData.get(slot + namespace);
                    if (stored) {
                        let nbt = stored.tag ? stored.tag.toString() : '';
                        entity.server.runCommandSilent(`item replace entity ${name} armor.${slot} with ${stored.id}${nbt}`);
                        entity.persistentData.remove(slot + namespace);
                    }
                });

                entity.persistentData.remove('hasStoredArmor');
            } else if (target === 'mainhand' && entity.persistentData.getBoolean('hasStoredMainhand')) {
                let stored = entity.persistentData.get(namespace);
                if (stored) {
                    let nbt = stored.tag ? stored.tag.toString() : '';
                    let count = entity.persistentData.getInt(namespace + '_mainhand_count') || 1;
                    entity.server.runCommandSilent(`item replace entity ${name} weapon.mainhand with ${stored.id}${nbt} ${count}`);
                    entity.persistentData.remove(namespace);
                    entity.persistentData.remove(namespace + '_mainhand_count');
                    entity.persistentData.remove('hasStoredMainhand');
                }
            } else if (target === 'offhand' && entity.persistentData.getBoolean('hasStoredOffhand')) {
                let stored = entity.persistentData.get(namespace);
                if (stored) {
                    let nbt = stored.tag ? stored.tag.toString() : '';
                    let count = entity.persistentData.getInt(namespace + '_offhand_count') || 1;
                    entity.server.runCommandSilent(`item replace entity ${name} weapon.offhand with ${stored.id}${nbt} ${count}`);
                    entity.persistentData.remove(namespace);
                    entity.persistentData.remove(namespace + '_offhand_count');
                    entity.persistentData.remove('hasStoredOffhand');
                }
            }
        });
});
