function rayTrace(entity, distance) {
    let eyePos = entity.getEyePosition(1);
    let viewVec = entity.motionDirection.normal;

    let endVec = eyePos.add(viewVec.x * distance, viewVec.y * distance, viewVec.z * distance);
    return entity.level.clip(new ClipContext(eyePos, endVec, "outline", "none", entity));
}

(function () {
    StartupEvents.registry('palladium:abilities', (event) => {

        event.create('fsang:teleportation_special')

            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('teleportation_distance', 'float', 10, 'the max distance to allow the player to teleport to.')

            .tick((entity, entry, holder, enabled) => {
                if (enabled) {
                    let teleportation_distance = entry.getPropertyByName('teleportation_distance');
                    let raytrace_block = rayTrace(entity, teleportation_distance);
            
                    if (raytrace_block && raytrace_block.hitResult && raytrace_block.hitResult.getLocation) {
                        let hitPos = raytrace_block.hitResult.getLocation();
                        // Adding a vertical offset to ensure teleportation above ground
                        entity.setPosition(hitPos.getX(), hitPos.getY() + 1.5, hitPos.getZ());
                    }
                }
            });
            
    });
})();
