(function () {
    // Register the X-ray vision ability
    StartupEvents.registry('palladium:abilities', (event) => {
        event.create('fsang:entity_highlight')
            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('glow_range', 'double', 50.0, 'Range in blocks to highlight entities') // Customizable range

            .tick((entity, entry, holder, enabled) => {
                // Ensure the logic only runs on the client side and for a player
                if (entity.level.isClientSide && entity.isPlayer()) {
                    // Retrieve the range property
                    let range = entry.getPropertyByName('glow_range');

                    // Get all entities around the player within the range
                    let nearbyEntities = entity.level.getEntities(entity, entity.getBoundingBox().inflate(range), e => e !== entity);

                    // Apply or remove the glowing effect based on the ability being enabled
                    nearbyEntities.forEach(nearbyEntity => {
                        if (enabled && (nearbyEntity.isPlayer() || nearbyEntity.isAlive())) {
                            // Set glowing effect when the ability is enabled
                            nearbyEntity.setGlowing(true);
                        } else {
                            // Remove glowing effect when the ability is disabled
                            nearbyEntity.setGlowing(false);
                        }
                    });
                }
            });
    });
})();
