// kubejs/server_scripts/fsang_rangers_score.js
ServerEvents.commandRegistry(event => {
    const { commands: Commands, arguments: Arguments } = event

    // Accepted colours and their scoreboard names
    const secondaryBoard = {
        symbiotesnatural: "FSang.2.Symb.Nat",
        symbiotesartificial: "FSang.2.Symb.Art",
        scarab: "FSang.2.Scarab",
        kaiju: "FSang.2.Kaiju",
        phoenixforce: "FSang.2.Phoenix",
        cosmic: "FSang.2.Cosmic"
    }

    event.register(
        Commands.literal("FSang.Secondary")
            .requires(src => src.hasPermission(2))               // ops or higher
            .then(
                Commands.argument("action", Arguments.STRING.create(event))  // add | remove
                    .suggests((ctx, b) => {
                        b.suggest("add").suggest("remove")
                        return b.buildFuture()
                    })
                    .then(
                        Commands.argument("power", Arguments.STRING.create(event)) // ranger colour
                            .suggests((ctx, b) => {
                                Object.keys(secondaryBoard).forEach(c => b.suggest(c))
                                return b.buildFuture()
                            })
                            .then(
                                Commands.argument("amount", Arguments.INTEGER.create(event)) // positive int
                                    .executes(ctx => {
                                        const player = ctx.source.player
                                        const action = Arguments.STRING.getResult(ctx, "action").toLowerCase()
                                        const colour = Arguments.STRING.getResult(ctx, "power").toLowerCase()
                                        const amount = Arguments.INTEGER.getResult(ctx, "amount")

                                        // basic validation
                                        if (!secondaryBoard[colour]) {
                                            player.tell(`§cUnknown power: ${colour}.`)
                                            return 0
                                        }
                                        if (amount <= 0) {
                                            player.tell("§cAmount must be a positive whole number.")
                                            return 0
                                        }
                                        if (action !== "add" && action !== "remove") {
                                            player.tell("§cAction must be 'add' or 'remove'.")
                                            return 0
                                        }

                                        const board = secondaryBoard[colour]
                                        palladium.scoreboard.addScore(
                                            player,
                                            board,
                                            action === "add" ? amount : -amount
                                        )

                                        player.tell(
                                            `§a${action === "add" ? "Added" : "Removed"} ${amount} ` +
                                            `to ${board}.`
                                        )
                                        return 1
                                    })
                            )
                    )
            )
    )
})
