BlockEvents.broken(event => {
    if (event.block.id === 'fsang:kryptonite_large_bud') {
        let pos = event.block.pos;
        let randomChance = Math.random();
        if (randomChance < 0.5) {
            event.server.runCommandSilent(`summon minecraft:item ${pos.x} ${pos.y + 0.5} ${pos.z} {Item:{id:"fsang:kryptonite_shard",Count:3}}`);
        } else {
            event.server.runCommandSilent(`summon minecraft:item ${pos.x} ${pos.y + 0.5} ${pos.z} {Item:{id:"fsang:kryptonite_shard",Count:2}}`);
        }
    }
});

BlockEvents.rightClicked('fsang:kryptonite_block', event => {
    const { player, hand, server, level } = event;
    const heldItem = player.getItemInHand(hand);
    let pos = event.block.pos;

    // Only proceed if the block above is air
    const blockAbove = level.getBlock(pos.above());
    if (!blockAbove.id.equals('minecraft:air')) return;

    if (heldItem.id !== 'fsang:kryptonite_shard') return;

    heldItem.shrink(1);

    server.scheduleInTicks(1, () => {
        server.runCommandSilent(`fill ${pos.x} ${pos.y + 1} ${pos.z} ${pos.x} ${pos.y + 1} ${pos.z} fsang:kryptonite_small_bud replace minecraft:air`);
    });
});
