// Track cooldowns to prevent overlap
let mjolnirCooldown = {};

ItemEvents.rightClicked(e => {
    const { hand, player, item, server, player: { mainHandItem, offhandItem } } = e;
    let playerName = player.name.string;
    let uuid = player.uuid;

    // Only trigger if crouching, holding Mjolnir, and offhand is empty
    if (!player.isCrouching() || mainHandItem.id !== "fsang:mjolnir" || offhandItem.id !== "minecraft:air") return;

    // Prevent rapid switching (20 ticks = 1 second)
    let lastUse = mjolnirCooldown[uuid] || 0;
    if (server.tickCount - lastUse < 20) return;

    // Get current name (default to empty if none)
    let currentName = mainHandItem.nbt?.display?.Name || "";

    // If name is not "[PlayerName]'s Mjolnir", rename it
    if (currentName !== `{"text":"${playerName}'s Mjolnir"}`) {
        player.setItemInHand(hand, Item.of('fsang:mjolnir', { display: { Name: `{"text":"${playerName}'s Mjolnir"}` } }));
    }
    // If it already has a custom name, reset to "Mjolnir"
    else {
        player.setItemInHand(hand, Item.of('fsang:mjolnir', { display: { Name: `{"text":"Mjolnir"}` } }));
    }

    // Update cooldown
    mjolnirCooldown[uuid] = server.tickCount;
});
