const mutationWeights = [
    { power: 'fsang:colossus', weight: 5, name: "Metal Mimicry (Organic Steel)" },
    { power: 'fsang:colossus2', weight: 5, name: "Metal Mimicry (Organic Diamond)" },
    { power: 'fsang:cyclops', weight: 5, name: "Optic Blasts" },
    { power: 'fsang:teleportation', weight: 3, name: "Teleportation" },
    { power: 'fsang:storm', weight: 3, name: "Weather Manipulation" },
    { power: 'fsang:wolverine', weight: 3, name: "Bone Claws (Logan)" },
    { power: 'fsang:wolverine2', weight: 3, name: "Bone Claws (Laura)" },
    { power: 'fsang:wolverine3', weight: 3, name: "Bone Claws (Daken)" },
    { power: 'fsang:phasing', weight: 8, name: "Phasing" },
    { power: 'fsang:pyrokinesis', weight: 5, name: "Pyrokinesis" },
    { power: 'fsang:electrokinesis', weight: 8, name: "Electrokinesis" },
    { power: 'fsang:cryokinesis', weight: 3, name: "Cryokinesis" },
    { power: 'fsang:angel', weight: 3, name: "Winged Flight" },
    { power: 'fsang:self_detonation', weight: 8, name: "Self Detonation" },
    { power: 'fsang:apocalypse', weight: 1, name: "En Sabah Nur" },
    { power: 'fsang:invisibility', weight: 8, name: "Invisibility" },
    { power: 'fsang:regenerative_healing', weight: 2, name: "Regenerative Healing" },
    { power: 'fsang:magnetism', weight: 1, name: "Magnetism" },
    { power: 'fsang:eye_mutation', weight: 8, name: "Eyes" },
    { power: 'fsang:face_change', weight: 8, name: "Face Morph" },
    { power: 'fsang:darwin', weight: 2, name: "Superior Adaptation" },
    { power: 'fsang:havok', weight: 8, name: "Plasma Energy Conversion" },
    { power: 'fsang:mimicry', weight: 1, name: "Mimicry" },
    { power: 'fsang:luck_mutation', weight: 8, name: "Luck" },
    { power: 'fsang:reality_warping', weight: 1, name: "Reality Warping" },
    { power: 'fsang:gambit', weight: 3, name: "Kinetic Energy Conversion" },
    { power: 'fsang:telepathy', weight: 3, name: "Telepathy" },
    { power: 'fsang:telekinesis', weight: 3, name: "Telekinesis" },
    { power: 'fsang:sabretooth', weight: 3, name: "Lupine" },
    { power: 'fsang:speed_mutation', weight: 5, name: "Speed" },
    { power: 'fsang:size_change', weight: 8, name: "Size Manipulation" },
    { power: 'fsang:forgetmenot', weight: 8, name: "????" },
    { power: 'fsang:sound_mutation', weight: 5, name: "Sonic Sound Manipulation" },
    { power: 'fsang:vulcan', weight: 1, name: "Energy Manipulation" },
    { power: 'fsang:telep_telek', weight: 1, name: "Telepathy / Telekinesis" },
    { power: 'fsang:telep_col', weight: 1, name: "Telepathy / Metal Mimicry (Organic Diamond)" },
    { power: 'fsang:time', weight: 1, name: "Chronokinesis" },
    { power: 'fsang:leech_mutation', weight: 5, name: "Power Negation" }
];

const LowermutationWeights = [
    { power: 'fsang:colossus', weight: 5, name: "Metal Mimicry (Organic Steel)" },
    { power: 'fsang:colossus2', weight: 5, name: "Metal Mimicry (Organic Diamond)" },
    { power: 'fsang:cyclops', weight: 5, name: "Optic Blasts" },
    { power: 'fsang:storm', weight: 3, name: "Weather Manipulation" },
    { power: 'fsang:angel', weight: 1, name: "Winged Flight" },
    { power: 'fsang:wolverine3', weight: 1, name: "Bone Claws (Daken)" },
    { power: 'fsang:gambit', weight: 1, name: "Kinetic Energy Conversion" },
    { power: 'fsang:phasing', weight: 8, name: "Phasing" },
    { power: 'fsang:pyrokinesis', weight: 5, name: "Pyrokinesis" },
    { power: 'fsang:electrokinesis', weight: 8, name: "Electrokinesis" },
    { power: 'fsang:cryokinesis', weight: 3, name: "Cryokinesis" },
    { power: 'fsang:self_detonation', weight: 8, name: "Self Detonation" },
    { power: 'fsang:invisibility', weight: 8, name: "Invisibility" },
    { power: 'fsang:eye_mutation', weight: 8, name: "Eyes" },
    { power: 'fsang:face_change', weight: 8, name: "Face Morph" },
    { power: 'fsang:havok', weight: 8, name: "Plasma Energy Conversion" },
    { power: 'fsang:luck_mutation', weight: 8, name: "Luck" },
    { power: 'fsang:speed_mutation', weight: 5, name: "Speed" },
    { power: 'fsang:size_change', weight: 8, name: "Size Manipulation" },
    { power: 'fsang:sound_mutation', weight: 5, name: "Sonic Sound Manipulation" },
    { power: 'fsang:leech_mutation', weight: 5, name: "Power Negation" },
    { power: 'fsang:forgetmenot', weight: 8, name: "????" },
    { power: 'fsang:time', weight: 1, name: "Chronokinesis" }
];

function getRandomMutation() {
    const totalWeight = mutationWeights.reduce((acc, mutation) => acc + mutation.weight, 0);
    let random = Math.random() * totalWeight;

    for (const mutation of mutationWeights) {
        if (random < mutation.weight) {
            return mutation;
        }
        random -= mutation.weight;
    }
}

function getRandomLowerMutation() {
    const totalWeight = LowermutationWeights.reduce((acc, mutation) => acc + mutation.weight, 0);
    let random = Math.random() * totalWeight;

    for (const mutation of LowermutationWeights) {
        if (random < mutation.weight) {
            return mutation;
        }
        random -= mutation.weight;
    }
}

function getRandomScore(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

ItemEvents.rightClicked(event => {
    const { player, item, server, hand } = event;

    // Check if the item is "fsang:x_gene"
    if (item.id === 'fsang:x_gene') {

        server.runCommandSilent(`scoreboard objectives add X_Gene dummy`);
        server.runCommandSilent(`scoreboard objectives add FSang.Telepathy.Color dummy`);
        server.runCommandSilent(`scoreboard objectives add FSang.Electrokinesis.Color dummy`);
        // Remove all existing powers first
        event.server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang:all`);

        // Assign random mutation based on weights
        const assignedMutation = getRandomMutation();

        const inEnd = player.level.dimension === 'minecraft:the_end';

        // Special logic for Wolverine, Teleportation, and Cyclops
        if (assignedMutation.power === 'fsang:teleportation') {
            const randomTeleportationScore = getRandomScore(0, 90);
            server.runCommandSilent(`scoreboard players set ${player.name.string} X_Gene ${randomTeleportationScore}`);
        } else if (assignedMutation.power === 'fsang:cyclops') {
            // Give the player Cyclops glasses along with the power
            player.give(Item.of('fsang:cyclops_glasses'));
        } else if (assignedMutation.power === 'fsang:telepathy') {
            // Give the player Cyclops glasses along with the power
            const randomTelepathyScore = getRandomScore(1, 8);
            server.runCommandSilent(`scoreboard players set ${player.name.string} FSang.Telepathy.Color ${randomTelepathyScore}`);
        } else if (assignedMutation.power === 'fsang:electrokinesis') {
            // Give the player Cyclops glasses along with the power
            const randomElectrokinesisScore = getRandomScore(1, 3);
            server.runCommandSilent(`scoreboard players set ${player.name.string} FSang.Electrokinesis.Color ${randomElectrokinesisScore}`);
        }
        // Assign the player the corresponding mutation power
        superpowerUtil.addSuperpower(player, assignedMutation.power);

        // Send a message in the player's chat window
        player.tell(`You have been granted the mutation power: ${assignedMutation.name}`);

        // Explicitly remove the item from the player's main hand
        player.setItemInHand(hand, Item.of('minecraft:air'));
    }
    if (item.id === 'fsang:reality_warping_potion') {

        server.runCommandSilent(`scoreboard objectives add X_Gene dummy`);
        server.runCommandSilent(`scoreboard objectives add FSang.Telepathy.Color dummy`);
        server.runCommandSilent(`scoreboard objectives add FSang.Electrokinesis.Color dummy`);
        // Remove all existing powers first
        event.server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang:all`);

        // Assign random mutation based on weights
        const assignedMutation = getRandomLowerMutation();

        const inEnd = player.level.dimension === 'minecraft:the_end';

        // Special logic for Wolverine, Teleportation, and Cyclops
        if (assignedMutation.power === 'fsang:teleportation') {
            const randomTeleportationScore = getRandomScore(0, 90);
            server.runCommandSilent(`scoreboard players set ${player.name.string} X_Gene ${randomTeleportationScore}`);
        } else if (assignedMutation.power === 'fsang:cyclops') {
            // Give the player Cyclops glasses along with the power
            player.give(Item.of('fsang:cyclops_glasses'));
        } else if (assignedMutation.power === 'fsang:telepathy') {
            // Give the player Cyclops glasses along with the power
            const randomTelepathyScore = getRandomScore(1, 8);
            server.runCommandSilent(`scoreboard players set ${player.name.string} FSang.Telepathy.Color ${randomTelepathyScore}`);
        } else if (assignedMutation.power === 'fsang:electrokinesis') {
            // Give the player Cyclops glasses along with the power
            const randomElectrokinesisScore = getRandomScore(1, 3);
            server.runCommandSilent(`scoreboard players set ${player.name.string} FSang.Electrokinesis.Color ${randomElectrokinesisScore}`);
        }
        // Assign the player the corresponding mutation power
        superpowerUtil.addSuperpower(player, assignedMutation.power);

        // Send a message in the player's chat window
        player.tell(`You have been granted the mutation power: ${assignedMutation.name}`);

        // Explicitly remove the item from the player's main hand
        player.setItemInHand(hand, Item.of('minecraft:air'));
    }
});

// Track if a player has already been assigned a mutation from the grant_x_gene ability
const assignedGenePlayers = new Set();

PlayerEvents.tick(event => {
    const player = event.player;

    if (abilityUtil.isEnabled(player, 'fsang:grant_x_gene', 'power_granted')) {
        if (!assignedGenePlayers.has(player.name.string)) {
            assignedGenePlayers.add(player.name.string);

            event.server.runCommandSilent(`scoreboard objectives add X_Gene dummy`);
            event.server.runCommandSilent(`scoreboard objectives add FSang.Telepathy.Color dummy`);
            event.server.runCommandSilent(`scoreboard objectives add FSang.Electrokinesis.Color dummy`);
            event.server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang:all`);

            const assignedMutation2 = getRandomMutation();

            if (assignedMutation2.power === 'fsang:teleportation') {
                const score = getRandomScore(0, 90);
                event.server.runCommandSilent(`scoreboard players set ${player.name.string} X_Gene ${score}`);
            } else if (assignedMutation2.power === 'fsang:cyclops') {
                player.give(Item.of('fsang:cyclops_glasses'));
            } else if (assignedMutation2.power === 'fsang:telepathy') {
                const score = getRandomScore(1, 8);
                event.server.runCommandSilent(`scoreboard players set ${player.name.string} FSang.Telepathy.Color ${score}`);
            } else if (assignedMutation2.power === 'fsang:electrokinesis') {
                const score = getRandomScore(1, 3);
                event.server.runCommandSilent(`scoreboard players set ${player.name.string} FSang.Electrokinesis.Color ${score}`);
            }

            superpowerUtil.addSuperpower(player, assignedMutation2.power);
            player.tell(`You have been granted the mutation power: ${assignedMutation2.name}`);

            // Remove the grant ability after applying
            event.server.runCommandSilent(`superpower remove fsang:grant_x_gene ${player.name.string}`);
        }
    } else {
        assignedGenePlayers.delete(player.name.string);
    }
});

PlayerEvents.tick(event => {
    const player = event.player;

    if (abilityUtil.isEnabled(player, 'fsang:power_reset', 'power_granted')) {
        // Lock all currently active powers
        let activePowers = palladium.powers.getPowerIds(player);
        activePowers.forEach(id => {
            event.server.runCommandSilent(`execute as ${player.name.string} run ability lock @s ${id} all`);
        });

        // Remove the grant ability after applying
        event.server.runCommandSilent(`effect clear ${player.name.string} fsang:power_reset`);
    }
});

const mutationPowers = [
    'fsang:cyclops',
    'fsang:colossus',
    'fsang:colossus2',
    'fsang:self_detonation',
    'fsang:storm',
    'fsang:wolverine',
    'fsang:wolverine2',
    'fsang:wolverine3',
    'fsang:pyrokinesis',
    'fsang:electrokinesis',
    'fsang:cryokinesis',
    'fsang:havok',
    'fsang:teleportation',
    'fsang:angel',
    'fsang:apocalypse',
    'fsang:regenerative_healing',
    'fsang:magnetism',
    'fsang:darwin',
    'fsang:mimicry',
    'fsang:reality_warping',
    'fsang:phasing',
    'fsang:invisibility',
    'fsang:eye_mutation',
    'fsang:luck_mutation',
    'fsang:face_change',
    'fsang:gambit',
    'fsang:telepathy',
    'fsang:speed_mutation',
    'fsang:size_change',
    'fsang:vulcan',
    'fsang:sound_mutation',
    'fsang:sabretooth',
    'fsang:telekinesis',
    'fsang:time',
    'fsang:forgetmenot',
    'fsang:leech_mutation'
];

EntityEvents.hurt(event => {
    const player = event.entity;
    if (!player || !player.isPlayer()) return;
    if (player.level.dimension !== 'minecraft:the_end') return;

    const damage = event.damage;
    const health = player.health;
    // Only proceed on would-be lethal damage
    if (damage < health) return;

    // Require Phoenix DNA specifically in offhand
    const off = player.offHandItem;
    if (!off || off.empty || off.id !== 'fsang:phoenix_dna') return;

    // Require a qualifying mutation and ensure Phoenix isn’t already owned
    const hasMutation = mutationPowers.some(power => palladium.superpowers.hasSuperpower(player, power));
    if (!hasMutation) return;
    if (palladium.superpowers.hasSuperpower(player, 'fsang_secondary:phoenix_force')) return;

    // Check next tick to confirm Totem actually triggered (regen/absorption/fire_res)
    player.server.scheduleInTicks(200, () => {
        const hasTotemEffects =
            player.hasEffect('minecraft:regeneration') &&
            player.hasEffect('minecraft:absorption') &&
            player.hasEffect('minecraft:fire_resistance');

        if (!hasTotemEffects) return;

        // Chance gate (as written, always true; change < 1 to e.g. < 0.25 for 25% if desired)
        if (Math.random() < 0.01) {
            palladium.superpowers.addSuperpower(player, 'fsang_secondary:phoenix_force');
            player.tell('§6You have become the host of the §cPhoenix Force§6.');
        }
    });
});











