(function(){
    let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');
    let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper');

    StartupEvents.registry('palladium:condition_serializer', (event) => {
        

        event.create('fsang:get_energy_condition')

        .addProperty('energy', 'integer', 10, 'Amount of energy to compare')
        .addProperty('id', 'string', "fsang:arc_reactor", 'Item to look for in curios slot')
        .addProperty('curios_slot', 'string', "body", 'curios slot id')
		.addProperty('trinket_slot', 'string', "chest/cape", 'trinket slot id')


        .test((entity, props) => {
            if (props.containsKey("id") && props.containsKey("energy") && props.containsKey("curios_slot")) {
				let curios_slot = props.get("curios_slot")
				let trinket_slot = props.get("trinket_slot")
				let energycompare = props.get("energy") 
				let id = props.get("id")

				let items = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? curios_slot : trinket_slot);
				
				for (let i = 0; i < items.length; i++) {
					let item = items[i];
					if (item.id === id) {
						let holderWrapper = EnergyHelper.getFromItemStack(item)

						if (holderWrapper.isPresent()) {
							let energyHolder = holderWrapper.get()

							if (energyHolder.getEnergyAmount() >= energycompare) {
								return true
							}
						}
					}
				}
			}
			return false
        })
    });
})() 