(function () {
    let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');
    let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper');

    // Register the ability
    StartupEvents.registry('palladium:abilities', (event) => {
        event.create('fsang:set_rf_to_scoreboard')

            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))

            .addProperty('curios_slot', 'string', "null", 'Curios slot ID (set to "null" to skip)')
            .addProperty('trinket_slot', 'string', "null", 'Trinket slot ID (set to "null" to skip)')
            .addProperty('armor_or_hand_slot', 'string', "null", 'Armor or hand slot (head, chest, legs, feet, mainhand, offhand, null)')
            .addProperty('scoreboard_rf', 'string', 'rf_scoreboard', 'Name of the scoreboard to set the RF value to')
            .addProperty('scoreboard_max', 'string', 'max_rf_scoreboard', 'Name of the scoreboard to set the max capacity to')

            .tick((entity, entry, holder, enabled) => {
                if (!enabled || !entity.isPlayer()) { return; }

                const curios_slot = entry.getPropertyByName('curios_slot') || "null";
                const trinket_slot = entry.getPropertyByName('trinket_slot') || "null";
                const armor_or_hand_slot = entry.getPropertyByName('armor_or_hand_slot') || "null";
                const scoreboard_rf = entry.getPropertyByName('scoreboard_rf');
                const scoreboard_max = entry.getPropertyByName('scoreboard_max');

                let scoreboard = Utils.server.scoreboard;
                let sbRfObj = scoreboard.getObjective(scoreboard_rf);
                let sbMaxObj = scoreboard.getObjective(scoreboard_max);
                if (!sbRfObj || !sbMaxObj) { return; } // Ensure the scoreboards exist

                let playerRfScore = scoreboard.getOrCreatePlayerScore(entity.getGameProfile().getName(), sbRfObj);
                let playerMaxScore = scoreboard.getOrCreatePlayerScore(entity.getGameProfile().getName(), sbMaxObj);

                // Function to get RF and max capacity from the item and set them to the scoreboards
                function setRFAndMaxCapacityToScoreboards(item) {
                    if (item && !item.isEmpty()) {
                        let holderWrapper = EnergyHelper.getFromItemStack(item);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            let currentEnergy = energyHolder.getEnergyAmount();
                            let maxEnergy = energyHolder.getEnergyCapacity();

                            // Set the current RF value and max capacity to the scoreboards
                            playerRfScore.setScore(currentEnergy);
                            playerMaxScore.setScore(maxEnergy);
                        }
                    }
                }

                // Process Curios and Trinkets slots
                if (curios_slot.toLowerCase() !== "null") {
                    let curiosItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, curios_slot.toLowerCase());
                    curiosItems.forEach(setRFAndMaxCapacityToScoreboards);
                }

                if (trinket_slot.toLowerCase() !== "null") {
                    let trinketItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, trinket_slot.toLowerCase());
                    trinketItems.forEach(setRFAndMaxCapacityToScoreboards);
                }

                // Process armor or hand slots
                if (armor_or_hand_slot.toLowerCase() !== "null") {
                    let itemToCheck;
                    switch (armor_or_hand_slot.toLowerCase()) {
                        case "head":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.HEAD);
                            break;
                        case "chest":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.CHEST);
                            break;
                        case "legs":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.LEGS);
                            break;
                        case "feet":
                            itemToCheck = entity.getEquippedStack(EquipmentSlot.FEET);
                            break;
                        case "mainhand":
                            itemToCheck = entity.getMainHandItem();
                            break;
                        case "offhand":
                            itemToCheck = entity.getOffhandItem();
                            break;
                    }
                    setRFAndMaxCapacityToScoreboards(itemToCheck);
                }
            });
    });
})();
