// Register the ability
StartupEvents.registry('palladium:abilities', (event) => {
    event.create('fsang:divide_scoreboard')
        .icon(palladium.createItemIcon('minecraft:command_block')) // Icon for the ability
        .addProperty('input_scoreboard', 'string', 'input_score', 'Name of the scoreboard to read from')  // Input scoreboard
        .addProperty('output_scoreboard', 'string', 'output_score', 'Name of the scoreboard to write to') // Output scoreboard
        .addProperty('division_value', 'integer', 1, 'The number to divide the input score by')  // Division factor

        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                const inputScoreboardName = entry.getPropertyByName('input_scoreboard');
                const outputScoreboardName = entry.getPropertyByName('output_scoreboard');
                const divisionValue = entry.getPropertyByName('division_value');
                
                let player = entity;
                let scoreboard = Utils.server.scoreboard;
                
                // Get the input scoreboard objective
                let inputObjective = scoreboard.getObjective(inputScoreboardName);
                if (inputObjective != null) {
                    let inputScore = scoreboard.getOrCreatePlayerScore(player.getGameProfile().getName(), inputObjective).getScore();

                    // Perform division if the division value is not zero
                    if (divisionValue !== 0) {
                        let dividedValue = Math.floor(inputScore / divisionValue);

                        // Get the output scoreboard objective
                        let outputObjective = scoreboard.getObjective(outputScoreboardName);
                        if (outputObjective != null) {
                            scoreboard.getOrCreatePlayerScore(player.getGameProfile().getName(), outputObjective).setScore(dividedValue);
                        }
                    }
                }
            }
        });
});
