const speedLevels = [0.0, 0.39, 0.78, 1.17, 1.56, 1.95, 2.34, 2.73, 3.12, 3.51, 4.0]



StartupEvents.registry('palladium:abilities', (event) => {

    

    event.create('fsang:add_speed_levels')

    .icon(palladium.createItemIcon('minecraft:feather'))

    .tick((entity, entry, holder, enabled) => {

        if (enabled) {

            const currentSpeed = palladium.getProperty(entity, 'FSang.SpeedLevel')



            if (currentSpeed >= speedLevels.length - 1) { return } // if out of bounds, bail

            var nextSpeed = speedLevels[currentSpeed+1]



            entity.modifyAttribute("minecraft:generic.movement_speed", "98fe7bf4-68c3-410a-9a65-9c5872251a7a", nextSpeed, "ADDITION")



            palladium.setProperty(entity, 'FSang.SpeedLevel', currentSpeed+1);

        };

    });

    

    event.create('fsang:remove_speed_levels')

    .icon(palladium.createItemIcon('minecraft:anvil'))

    .tick((entity, entry, holder, enabled) => {

        if (enabled) {

            const currentSpeed = palladium.getProperty(entity, 'FSang.SpeedLevel')

            if (currentSpeed - 1 < 0) { return } // if out of bounds, bail

            var nextSpeed = speedLevels[currentSpeed-1]



            entity.modifyAttribute("minecraft:generic.movement_speed", "98fe7bf4-68c3-410a-9a65-9c5872251a7a", nextSpeed, "ADDITION")



            palladium.setProperty(entity, 'FSang.SpeedLevel', currentSpeed-1);

        };

    });

    

    event.create('fsang:reset_speed_levels')

    .icon(palladium.createItemIcon('minecraft:anvil'))

    .tick((entity, entry, holder, enabled) => {

        if (enabled) {

            entity.removeAttribute("minecraft:generic.movement_speed", "98fe7bf4-68c3-410a-9a65-9c5872251a7a")

            palladium.setProperty(entity, 'FSang.SpeedLevel', 0);

        };

    });

});



StartupEvents.registry('palladium:condition_serializer', (event) => {



    event.create('fsang:above_speed_levels')

    .addProperty("speedforce_id", "string", "speedLevel", "ID used for speed control")

    .addProperty("amount", "integer", 1, "Amount control needs to be over or meet")

    .test((entity, props) => {

        let speedforce_id = props.get("speedforce_id")

        let amount = props.get("amount")

        let playerSpeed = palladium.getProperty(entity, speedforce_id)

        return playerSpeed >= amount

    })



    event.create('fsang:below_speed_levels')

    .addProperty("speedforce_id", "string", "speedLevel", "ID used for speed control")

    .addProperty("amount", "integer", 1, "Amount control needs to be under")

    .test((entity, props) => {

        let speedforce_id = props.get("speedforce_id")

        let amount = props.get("amount")

        let playerSpeed = palladium.getProperty(entity, speedforce_id)

        return playerSpeed < amount

    })



});