const spiderPowerWeights = [
    { power: "fsang:spiderman", weight: 4, name: "Arachnid - Peter Parker" },
    { power: "fsang:spiderman_kaine", weight: 2, name: "Arachnid - Kaine Parker" },
    { power: "fsang:spiderman_miguel", weight: 2, name: "Arachnid - Miguel O'Hara" },
    { power: "fsang:spiderman_jessica", weight: 2, name: "Arachnid - Jessica Drew" },
    { power: "fsang:spiderman_miles", weight: 2, name: "Arachnid - Miles Morales" },
    { power: "fsang:spiderman_silk", weight: 2, name: "Arachnid - Cindy Moon" }
];

function getRandomSpiderPower() {
    const totalWeight = spiderPowerWeights.reduce((acc, mutation) => acc + mutation.weight, 0);
    let random = Math.random() * totalWeight;

    for (const mutation of spiderPowerWeights) {
        if (random < mutation.weight) {
            return mutation;
        }
        random -= mutation.weight;
    }
}
function getRandomScore(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

ItemEvents.rightClicked(event => {
    const { hand, player, server, player: { username, mainHandItem, offhandItem } } = event;

    if (mainHandItem.id == "fsang:spider_serum") {
        const selectedPower2 = getRandomSpiderPower(spiderPowerWeights.power);
        player.setItemInHand(hand, "minecraft:air")

        server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

        superpowerUtil.addSuperpower(player, selectedPower2.power);
        player.tell(`You have been granted the Arachnid Variant: ${selectedPower2.name}`);
    }
});
