var SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil');

function randInt(min, max) { return Math.floor(Math.random() * (max - min + 1)) + min; }

function fsang_setRandomTrailProps(player) {
    function randHex6() { return Math.floor(Math.random() * 0x1000000).toString(16).padStart(6, '0'); }
    const c1 = parseInt(randHex6(), 16);
    const c2 = parseInt(randHex6(), 16);
    try {
        palladium.setProperty(player, 'fsang_speed_trail1', c1);
        palladium.setProperty(player, 'fsang_speed_trail2', c2);
    } catch (_) {
        if (typeof propertyUtil !== 'undefined') {
            propertyUtil.set(player, 'fsang_speed_trail1', c1);
            propertyUtil.set(player, 'fsang_speed_trail2', c2);
        }
    }
}


var TIER = {
    S: [
        { power: 'fsang:anti_matter', name: 'Anti Matter', weight: 1 },
        { power: 'fsang:lobo', name: 'Czarnian', weight: 1 },
        { power: 'fsang:apocalypse', name: 'En Sabah Nur', weight: 1 },
        { power: 'fsang:vulcan', name: 'Energy Manipulation', weight: 1 },
        { power: 'fsang:hulk', name: 'Hulk', weight: 1 },
        { power: 'fsang:kree_hybrid', name: 'Kree-Hybrid', weight: 1 },
        { power: 'fsang:kryptonian', name: 'Kryptonian (Adventures)', weight: 1 },
        { power: 'fsang:kryptonian_cw', name: 'Kryptonian (CW)', weight: 1 },
        { power: 'fsang:kryptonian_dceu', name: 'Kryptonian (DCEU)', weight: 1 },
        { power: 'fsang:magnetism', name: 'Magnetism', weight: 1 },
        { power: 'fsang:martian_green', name: 'Martian (Green)', weight: 1 },
        { power: 'fsang:mimicry', name: 'Mimicry', weight: 1 },
        { power: 'fsang:radiant_black', name: 'Radiant - Black', weight: 1 },
        { power: 'fsang:reality_warping', name: 'Reality Warping', weight: 1 },
        { power: 'fsang:sentry', name: 'Sentry', weight: 1 },
        { power: 'fsang:viltrumite_thraxan', name: 'Viltrumite (Thraxan Hybrid)', weight: 1 },
        { power: 'fsang:viltrumite_scout', name: 'Viltrumite (Scout)', weight: 1 },
        { power: 'fsang:viltrumite_human', name: 'Viltrumite (Human Hybrid)', weight: 1 },
        { power: 'fsang:viltrumite', name: 'Viltrumite (Warrior)', weight: 1 },
        { power: 'fsang:viltrumite_brute', name: 'Viltrumite (Brute)', weight: 1 }
    ],
    A: [
        { power: 'fsang:asgardian2', name: 'Asgardian (Gatekeeper)', weight: 2 },
        { power: 'fsang:asgardian', name: 'Asgardian (Royal)', weight: 2 },
        { power: 'fsang:wolverine3', name: 'Wolverine (Daken)', weight: 2 },
        { power: 'fsang:wolverine2', name: 'Wolverine (Laura)', weight: 2 },
        { power: 'fsang:wolverine', name: 'Wolverine (Logan)', weight: 2 },
        { power: 'fsang:time', name: 'Chronokinesis', weight: 2 },
        { power: 'fsang:geokinesis', name: 'Geokinesis', weight: 2 },
        { power: 'fsang:spawn', name: 'Hellspawn', weight: 2 },
        { power: 'fsang:homelander', name: 'Homelander', weight: 2 },
        { power: 'fsang:kryptonian_half', name: 'Half-Kryptonian (Tactile Telekinesis)', weight: 1 },
        { power: 'fsang:kryptonian_half_yj', name: 'Half-Kryptonian (Young Justice)', weight: 1 },
        { power: 'fsang:sabretooth', name: 'Lupine', weight: 2 },
        { power: 'fsang:matter_aborption', name: 'Matter Absorption', weight: 2 },
        { power: 'fsang:human_torch', name: 'Pyrogenesis', weight: 2 },
        { power: 'fsang:regenerative_healing', name: 'Regenerative Healing', weight: 2 },
        { power: 'fsang:shazam', name: 'Shazam', weight: 2 },
        { power: 'fsang:speedforce', name: 'Speedforce (Avatar)', weight: 2 },
        { power: 'fsang:speedforce_speed', name: 'Speedforce (Speed)', weight: 2 },
        { power: 'fsang:speedforce_strength', name: 'Speedforce (Strength)', weight: 2 },
        { power: 'fsang:speedforce_tachyon', name: 'Speedforce (Tachyon)', weight: 2 },
        { power: 'fsang:speedforce_negative', name: 'Negative Speedforce (Avatar)', weight: 2 },
        { power: 'fsang:speedforce_leech', name: 'Negative Speedforce (Leech)', weight: 2 },
        { power: 'fsang:darwin', name: 'Superior Adaptation', weight: 2 },
        { power: 'fsang:telepathy', name: 'Telepathy', weight: 2 },
        { power: 'fsang:telep_col', name: 'Telepathy / Metal Mimicry', weight: 2 },
        { power: 'fsang:telep_telek', name: 'Telepathy / Telekinesis', weight: 2 }
    ],
    B: [
        { power: 'fsang:amazon', name: 'Amazon', weight: 4 },
        { power: 'fsang:spiderman', name: 'Arachnid (Peter Parker)', weight: 4 },
        { power: 'fsang:spiderman_jessica', name: 'Arachnid (Jessica Drew)', weight: 4 },
        { power: 'fsang:spiderman_kaine', name: 'Arachnid (Kaine Parker)', weight: 4 },
        { power: 'fsang:spiderman_miguel', name: "Arachnid (Miguel O'Hara)", weight: 4 },
        { power: 'fsang:spiderman_miles', name: 'Arachnid (Miles Morales)', weight: 4 },
        { power: 'fsang:spiderman_silk', name: 'Arachnid (Cindy Moon)', weight: 4 },
        { power: 'fsang:atlantean_sea_changed', name: 'Atlantean (Sea-Changed)', weight: 4 },
        { power: 'fsang:atlantean', name: 'Atlantean (Royal)', weight: 4 },
        { power: 'fsang:boogie_woogie', name: 'Cursed User (Boogie Woogie)', weight: 4 },
        { power: 'fsang:cryokinesis', name: 'Cryokinesis', weight: 4 },
        { power: 'fsang:gambit', name: 'Kinetic Energy Conversion', weight: 4 },
        { power: 'fsang:daredevil', name: 'Radioactive Blindness', weight: 4 },
        { power: 'fsang:speed_mutation', name: 'Speed Mutation', weight: 4 },
        { power: 'fsang:telekinesis', name: 'Telekinesis', weight: 4 },
        { power: 'fsang:teleportation', name: 'Teleportation', weight: 4 },
        { power: 'fsang:storm', name: 'Weather Manipulation', weight: 4 },
        { power: 'fsang:angel', name: 'Winged Flight', weight: 4 }
    ],
    C: [
        { power: 'fsang:colossus2', name: 'Metal Mimicry (Diamond)', weight: 6 },
        { power: 'fsang:colossus', name: 'Metal Mimicry (Steel)', weight: 6 },
        { power: 'fsang:cyclops', name: 'Optic Blasts', weight: 6 },
        { power: 'fsang:pyrokinesis', name: 'Pyrokinesis', weight: 6 },
        { power: 'fsang:sandman', name: 'Sand Manipulation', weight: 6 },
        { power: 'fsang:sound_mutation', name: 'Sonic Sound Manipulation', weight: 6 },
        { power: 'fsang:super_soldier', name: 'Super Soldier (Steve)', weight: 6 },
        { power: 'fsang:super_soldier_red_skull', name: 'Super Soldier (Red Skull)', weight: 6 },
        { power: 'fsang:super_soldier_winter_soldier', name: 'Super Soldier (Winter)', weight: 6 }
    ],
    D: [
        { power: 'fsang:electrokinesis', name: 'Electrokinesis', weight: 7 },
        { power: 'fsang:havok', name: 'Plasma Energy Conversion', weight: 7 },
        { power: 'fsang:leech_mutation', name: 'Power Negation', weight: 7 },
        { power: 'fsang:size_change', name: 'Size Manipulation', weight: 7 }
    ],
    E: [
        { power: 'fsang:eye_mutation', name: 'Eye Mutation', weight: 8 },
        { power: 'fsang:face_change', name: 'Face Change', weight: 8 },
        { power: 'fsang:forgetmenot', name: '??????', weight: 8 },
        { power: 'fsang:invisibility', name: 'Invisibility', weight: 8 },
        { power: 'fsang:luck_mutation', name: 'Luck Mutation', weight: 8 },
        { power: 'fsang:phasing', name: 'Phasing', weight: 8 },
        { power: 'fsang:self_detonation', name: 'Self Detonation', weight: 8 }
    ]
};

var ITEM_BEHAVIOR = {
    'fsang:random_power': { weighted: false, tiers: ['S', 'A', 'B', 'C', 'D', 'E'] },
    'fsang:random_power_2': { weighted: true, tiers: ['S', 'A', 'B', 'C', 'D', 'E'] },
    'fsang:random_power_upper': { weighted: true, tiers: ['S', 'A'] },
    'fsang:random_power_upper2': { weighted: false, tiers: ['S', 'A'] },
    'fsang:random_power_lower': { weighted: true, tiers: ['B', 'C', 'D', 'E'] },
    'fsang:random_power_lower2': { weighted: false, tiers: ['B', 'C', 'D', 'E'] }
};

function getPool(allowedTiers) {
    var out = [];
    for (var i = 0; i < allowedTiers.length; i++) {
        var list = TIER[allowedTiers[i]];
        if (list && list.length) Array.prototype.push.apply(out, list);
    }
    return out;
}

function pickUniform(list) {
    return list[Math.floor(Math.random() * list.length)];
}

function pickWeighted(list) {
    var total = 0;
    for (var i = 0; i < list.length; i++) total += (list[i].weight !== undefined ? list[i].weight : 1);
    var r = Math.random() * total;
    for (var j = 0; j < list.length; j++) {
        var w = (list[j].weight !== undefined ? list[j].weight : 1);
        if (r < w) return list[j];
        r -= w;
    }
    return list[list.length - 1];
}

function ensureObjectives(server) {
    server.runCommandSilent('scoreboard objectives add X_Gene dummy');
    server.runCommandSilent('scoreboard objectives add FSang.Telepathy.Color dummy');
    server.runCommandSilent('scoreboard objectives add SpeedsterTrail dummy');
    server.runCommandSilent('scoreboard objectives add NegativeSpeedsterTrail dummy');
}

function applySpecialCases(server, player, assigned) {
    var name = player.name.string;
    if (assigned.power === 'fsang:teleportation') server.runCommandSilent('scoreboard players set ' + name + ' X_Gene ' + randInt(0, 90));
    if (assigned.power === 'fsang:cyclops') player.give(Item.of('fsang:cyclops_glasses'));
    if (assigned.power === 'fsang:telepathy' || assigned.power === 'fsang:telekinesis' || assigned.power === 'fsang:telep_telek' || assigned.power === 'fsang:telep_col') {
        server.runCommandSilent('scoreboard players set ' + name + ' FSang.Telepathy.Color ' + randInt(1, 8));
    }

    var isSpeedforce =
        assigned.power === 'fsang:speedforce' ||
        assigned.power === 'fsang:speedforce_speed' ||
        assigned.power === 'fsang:speedforce_strength' ||
        assigned.power === 'fsang:speedforce_tachyon' ||
        assigned.power === 'fsang:speedforce_negative' ||
        assigned.power === 'fsang:negative_speedforce' ||
        assigned.power === 'fsang:speedforce_leech' ||
        assigned.power === 'fsang:speedforce_god';

    if (isSpeedforce) fsang_setRandomTrailProps(player);

    if (assigned.power === 'fsang:speedforce') server.runCommandSilent('scoreboard players set ' + name + ' SpeedsterTrail ' + randInt(0, 8));
    if (assigned.power === 'fsang:negative_speedforce' || assigned.power === 'fsang:speedforce_negative')
        server.runCommandSilent('scoreboard players set ' + name + ' NegativeSpeedsterTrail ' + randInt(0, 4));
}


function grantPower(server, player, hand, assigned) {
    server.runCommandSilent('execute as ' + player.name.string + ' run superpower remove fsang:all');
    SuperpowerUtil.addSuperpower(player, assigned.power);
    player.tell('Granted: ' + assigned.name);
    player.setItemInHand(hand, Item.of('minecraft:air'));
}

ItemEvents.rightClicked(function (event) {
    var player = event.player, item = event.item, server = event.server, hand = event.hand;
    var cfg = ITEM_BEHAVIOR[item.id];
    if (!cfg) return;
    ensureObjectives(server);
    var pool = getPool(cfg.tiers);
    if (!pool.length) { player.tell('No eligible powers configured for this item.'); return; }
    var chosen = cfg.weighted ? pickWeighted(pool) : pickUniform(pool);
    applySpecialCases(server, player, chosen);
    grantPower(server, player, hand, chosen);
});
