const TELEPORT_RANGE = 1.1;
const LIFESPAN_TICKS = 20 * 10; // 10 seconds
const PORTAL_TAG = "FSang.RealityWarp";
const PARTICLE = "dust_color_transition 0.67 0.91 0.92 1 0.17 0.4 0.58";
const SOUND = "minecraft:entity.enderman.teleport";

if (!global.portalAges) global.portalAges = {};
if (!global.portalCooldowns) global.portalCooldowns = {};

ServerEvents.tick(event => {
    const server = event.server;

    server.getAllLevels().forEach(level => {
        const portals = level.getEntities().filter(e =>
            e.type === 'minecraft:armor_stand' &&
            (e.tags.contains(`${PORTAL_TAG}.Portal1`) || e.tags.contains(`${PORTAL_TAG}.Portal2`))
        );

        portals.forEach(portal => {
            const uuid = portal.uuid.toString();
            global.portalAges[uuid] = (global.portalAges[uuid] || 0) + 1;

            level.players.forEach(player => {
                const dx = portal.x - player.x;
                const dy = portal.y - player.y;
                const dz = portal.z - player.z;
                const distance = Math.sqrt(dx * dx + dy * dy + dz * dz);

                if (distance <= TELEPORT_RANGE && !player.tags.contains("FSang.RealityWarp.Cooldown")) {
                    const otherTag = portal.tags.contains(`${PORTAL_TAG}.Portal1`) ? `${PORTAL_TAG}.Portal2` : `${PORTAL_TAG}.Portal1`;
                    const target = findLinkedPortal(server, otherTag);

                    if (target) {
                        teleportPlayerTo(player, target);
                        player.level.runCommandSilent(`particle ${PARTICLE} ${player.x} ${player.y + 1} ${player.z} 0.2 0.5 0.2 0 30 force`);
                        player.level.playSound(null, player.x, player.y, player.z, SOUND, "players", 1.0, 1.0);

                        player.addTag("FSang.RealityWarp.Cooldown");
                        global.portalCooldowns[player.uuid] = 40; // 2 seconds
                    }
                }
            });

            if (global.portalAges[uuid] > LIFESPAN_TICKS) {
                delete global.portalAges[uuid];
                portal.kill();
            }
        });
    });

    Object.keys(global.portalCooldowns).forEach(uuid => {
        global.portalCooldowns[uuid]--;
        if (global.portalCooldowns[uuid] <= 0) {
            const player = server.getPlayerList().getPlayer(uuid);
            if (player) player.removeTag("FSang.RealityWarp.Cooldown");
            delete global.portalCooldowns[uuid];
        }
    });
});

function findLinkedPortal(server, tag) {
    for (const level of server.getAllLevels()) {
        let entities = [];
        try {
            level.getLoadedChunks().forEach(chunk => {
                chunk.forceLoad(true);
            });
            entities = level.getEntities().filter(e =>
                e.type === 'minecraft:armor_stand' && e.tags.contains(tag)
            );
        } catch (e) {
            console.error("Error while loading chunks for portal search:", e);
        }
        if (entities.length > 0) return entities[0];
    }
    return null;
}

function teleportPlayerTo(player, target) {
    if (player.level !== target.level) {
        player.teleportTo(target.level, target.x, target.y, target.z);
    } else {
        player.teleportTo(target.x, target.y, target.z);
    }
}
