const speedforcePowers = [
    { power: 'fsang:speedforce', weight: 8, name: 'Speedforce (Avatar)' },
    { power: 'fsang:speedforce_tachyon', weight: 4, name: 'Speedforce (Tachyon)' },
    { power: 'fsang:speedforce_speed', weight: 6, name: 'Speedforce (Speed)' },
    { power: 'fsang:speedforce_strength', weight: 6, name: 'Speedforce (Strength)' },
    { power: 'fsang:negative_speedforce', weight: 4, name: 'Negative Speedforce (Avatar)' },
    { power: 'fsang:speedforce_leech', weight: 4, name: 'Negative Speedforce (Leech)' }
];

const TRAIL_RANGE = {
    'fsang:negative_speedforce': [0, 4],
    'fsang:speedforce_leech': [0, 4],
    default: [0, 8]
};

function weightedPick(list) {
    const total = list.reduce((s, x) => s + x.weight, 0);
    let r = Math.random() * total;
    for (const x of list) { if (r < x.weight) return x; r -= x.weight; }
    return list[list.length - 1];
}

function randInt(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

function randHex6() {
    return Math.floor(Math.random() * 0x1000000).toString(16).padStart(6, '0');
}

function setRandomTrailProps(player) {
    const h1 = randHex6();
    const h2 = randHex6();
    const c1 = parseInt(h1, 16);
    const c2 = parseInt(h2, 16);
    try {
        palladium.setProperty(player, 'fsang_speed_trail1', c1);
        palladium.setProperty(player, 'fsang_speed_trail2', c2);
    } catch (_) {
        if (typeof propertyUtil !== 'undefined') {
            propertyUtil.set(player, 'fsang_speed_trail1', c1);
            propertyUtil.set(player, 'fsang_speed_trail2', c2);
        }
    }
    return [h1, h2];
}

const assignedPlayers = new Set();

PlayerEvents.tick(event => {
    const player = event.player;

    if (!abilityUtil.isEnabled(player, 'fsang:speedster_chem', 'grant_power_com')) {
        assignedPlayers.delete(player.name.string);
        return;
    }
    if (assignedPlayers.has(player.name.string)) return;
    assignedPlayers.add(player.name.string);

    event.server.runCommandSilent('scoreboard objectives add SpeedsterTrail dummy');
    event.server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang:all`);

    const assignedPower = weightedPick(speedforcePowers);
    const [min, max] = TRAIL_RANGE[assignedPower.power] || TRAIL_RANGE.default;
    const trailScore = randInt(min, max);
    event.server.runCommandSilent(`scoreboard players set ${player.name.string} SpeedsterTrail ${trailScore}`);

    const [hex1, hex2] = setRandomTrailProps(player);

    superpowerUtil.addSuperpower(player, assignedPower.power);
    event.server.runCommandSilent(`superpower remove fsang:speedster_chem ${player.name.string}`);

    player.tell(`You have been granted: ${assignedPower.name}`);
    player.tell(`Primary Trail set: #${hex1}`);
    player.tell(`Secondary Trail set: #${hex2}`);
});
