const symbioteWeightsNatural = [
    { score: 1, name: "Venom", weight: 10, color: "dark_gray" },
    { score: 2, name: "Carnage", weight: 8, color: "red" },
    { score: 3, name: "Riot", weight: 8, color: "gray" },
    { score: 4, name: "Agony", weight: 6, color: "dark_purple" },
    { score: 5, name: "Lasher", weight: 4, color: "green" },
    { score: 6, name: "Phage", weight: 6, color: "yellow" },
    { score: 7, name: "Toxin", weight: 2, color: "dark_red" },
    { score: 8, name: "Scorn", weight: 8, color: "light_purple" },
    { score: 9, name: "Scream", weight: 1, color: "gold" },
    { score: 10, name: "Sleeper", weight: 3, color: "green" },
    { score: 11, name: "Host Rider", weight: 1, color: "gold" },
    { score: 12, name: "Fang", weight: 8, color: "green" },
    { score: 13, name: "Misery", weight: 8, color: "red" },
    { score: 14, name: "Hybrid", weight: 5, color: "dark_red" },
    { score: 15, name: "Grendel", weight: 5, color: "dark_gray" },
    { score: 16, name: "Curse", weight: 1, color: "blue" },
    { score: 17, name: "Death Angel", weight: 3, color: "dark_purple" },
    { score: 18, name: "Strain", weight: 4, color: "dark_purple" },
    { score: 19, name: "Thorn", weight: 4, color: "green" },
    { score: 20, name: "Reaper", weight: 4, color: "dark_gray" },
    { score: 21, name: "Blackout", weight: 6, color: "gray" },
    { score: 22, name: "Authority", weight: 3, color: "dark_red" },
    { score: 23, name: "Bloom", weight: 8, color: "green" },
    { score: 24, name: "Inumis", weight: 3, color: "dark_purple" },
    { score: 25, name: "Montechiari", weight: 5, color: "dark_gray" },
    { score: 26, name: "Sprain", weight: 5, color: "dark_green" },
    { score: 27, name: "Tempest", weight: 5, color: "dark_red" },
    { score: 28, name: "Aquamarine", weight: 5, color: "dark_red" },
    { score: 29, name: "Xenocive", weight: 5, color: "red" },
    { score: 98, name: "Wraith", weight: 0.0, color: "dark_red" },
    { score: 99, name: "Fallout", weight: 0.0, color: "dark_green" },
    { score: 100, name: "Creator", weight: 0.0, color: "gold" }
];

const symbioteWeights = [
    { score: 1, name: "Venom", weight: 10, color: "dark_gray" },
    { score: 2, name: "Carnage", weight: 8, color: "red" },
    { score: 3, name: "Riot", weight: 8, color: "gray" },
    { score: 4, name: "Agony", weight: 6, color: "dark_purple" },
    { score: 5, name: "Lasher", weight: 4, color: "green" },
    { score: 6, name: "Phage", weight: 6, color: "yellow" },
    { score: 7, name: "Toxin", weight: 0, color: "dark_red" },
    { score: 8, name: "Scorn", weight: 9, color: "light_purple" },
    { score: 9, name: "Scream", weight: 2, color: "gold" },
    { score: 10, name: "Sleeper", weight: 3, color: "green" }
];

function getRandomSymbiote() {
    const totalWeight = symbioteWeights.reduce((acc, symbiote) => acc + symbiote.weight, 0);
    let random = Math.random() * totalWeight;

    for (const symbiote of symbioteWeights) {
        if (random < symbiote.weight) {
            return symbiote;
        }
        random -= symbiote.weight;
    }
}

ItemEvents.rightClicked(event => {
    const { player, item, server, hand } = event;

    // Check if the item is "fsang:symbiote_artificial"
    if (item.id === 'fsang:symbiote_artificial') {
        let assignedSymbiote;

        // Assign random symbiote based on weights
        assignedSymbiote = getRandomSymbiote();

        server.runCommandSilent(`tag @s[tag=FSang.Symbiote.Natural] remove FSang.Symbiote.Natural`);
        server.runCommandSilent(`scoreboard objectives add Symbiote_Assigner dummy`);
        server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang_secondary:symbiote`);
        server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang_secondary:symbiote_natural`);

        // Assign the player the corresponding symbiote score
        server.runCommandSilent(`scoreboard players set ${player.name.string} Symbiote_Assigner ${assignedSymbiote.score}`);

        // Give the player the symbiote power
        superpowerUtil.addSuperpower(player, 'fsang_secondary:symbiote');

        // Send a colored message in the player's chat window using tellraw
        server.runCommandSilent(`tellraw ${player.name.string} {"text":"Hello, we are ${assignedSymbiote.name}","color":"${assignedSymbiote.color}"}`);

        // Explicitly remove the item from the player's main hand
        player.setItemInHand(hand, Item.of('minecraft:air'));
    }

});


function getRandomSymbioteNatural() {
    const totalWeight = symbioteWeightsNatural.reduce((acc, symbiote) => acc + symbiote.weight, 0);
    let random = Math.random() * totalWeight;

    for (const symbiote of symbioteWeightsNatural) {
        if (random < symbiote.weight) {
            return symbiote;
        }
        random -= symbiote.weight;
    }
}

PlayerEvents.tick(event => {
    const player = event.player;

    if (superpowerUtil.hasSuperpower(player, 'fsang:symbiote_birth')) {
        const assignedSymbiote = getRandomSymbioteNatural();
        event.server.runCommandSilent(`scoreboard objectives add Symbiote_Assigner dummy`);
        if (superpowerUtil.hasSuperpower(player, 'fsang:spirit_of_vengence')) {
            event.server.runCommandSilent(`scoreboard players set ${player.name.string} Symbiote_Assigner 11`);

            // Grant the symbiote power
            superpowerUtil.addSuperpower(player, `fsang_secondary:symbiote_natural`);

            event.server.runCommandSilent(`execute as ${player.name.string} run tellraw @s[scores={Symbiote_Assigner=11}] {"text":"I am Host Rider, a symbiote of vengeance. With me, ${player.name.string}, we will bring justice to the wicked.","color":"gold"}`);
        }
        else {
            // Assign the player the corresponding symbiote score
            event.server.runCommandSilent(`scoreboard players set ${player.name.string} Symbiote_Assigner ${assignedSymbiote.score}`);

            // Grant the symbiote power
            superpowerUtil.addSuperpower(player, `fsang_secondary:symbiote_natural`);




        }
        // Remove the 'fsang:symbiote_birth' power
        superpowerUtil.removeSuperpower(player, 'fsang:symbiote_birth');
    }
    else if (superpowerUtil.hasSuperpower(player, 'fsang:symbiote_birth2')) {
        const assignedSymbiote = getRandomSymbioteNatural();
        event.server.runCommandSilent(`scoreboard objectives add Symbiote_Assigner dummy`);
        if (superpowerUtil.hasSuperpower(player, 'fsang:spirit_of_vengence')) {
            event.server.runCommandSilent(`scoreboard players set ${player.name.string} Symbiote_Assigner 11`);

            // Grant the symbiote power
            superpowerUtil.addSuperpower(player, `fsang:symbiote_natural`);

            event.server.runCommandSilent(`execute as ${player.name.string} run tellraw @s[scores={Symbiote_Assigner=11}] {"text":"I am Host Rider, a symbiote of vengeance. With me, ${player.name.string}, we will bring justice to the wicked.","color":"gold"}`);
        }
        else {
            server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang_secondary:symbiote`);
            server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang_secondary:symbiote_natural`);
            // Assign the player the corresponding symbiote score
            event.server.runCommandSilent(`scoreboard players set ${player.name.string} Symbiote_Assigner ${assignedSymbiote.score}`);

            // Grant the symbiote power
            superpowerUtil.addSuperpower(player, `fsang_secondary:symbiote_natural`);




        }
        // Remove the 'fsang:symbiote_birth' power
        superpowerUtil.removeSuperpower(player, 'fsang:symbiote_birth2');
    }
});