(function () {
    const CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');
    const EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper');

    const armorSlotMap = {
        head: 'HEAD',
        chest: 'CHEST',
        legs: 'LEGS',
        feet: 'FEET'
    };

    StartupEvents.registry('palladium:abilities', (event) => {
        event.create('fsang:drain_per_tick')
            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('energy', 'integer', 10, 'Amount of energy to add/withdraw per tick')
            .addProperty('curios_slot', 'string', "null", 'Curios slot ID (set to "null" to skip)')
            .addProperty('trinket_slot', 'string', "null", 'Trinket slot ID (set to "null" to skip)')
            .addProperty('armor_or_hand_slot', 'string', "null", 'Armor or hand slot (head, chest, legs, feet, mainhand, offhand, null)')
            .addProperty('mode', 'string', "withdraw", 'Mode to either add or withdraw energy')
            .tick((entity, entry, holder, enabled) => {
                if (!enabled) return;

                const energy = entry.getPropertyByName('energy');
                const curiosSlot = entry.getPropertyByName("curios_slot")
                const trinketSlot = entry.getPropertyByName("trinket_slot")
                const slot = entry.getPropertyByName('armor_or_hand_slot')
                const mode = entry.getPropertyByName('mode')

                const modifyEnergy = (item) => {
                    if (!item || item.isEmpty()) return;
                    const wrapper = EnergyHelper.getFromItemStack(item);
                    if (wrapper.isPresent()) {
                        const energyHolder = wrapper.get();
                        if (mode === "withdraw") {
                            energyHolder.withdrawEnergy(energy, false);
                        } else if (mode === "add") {
                            energyHolder.insertEnergy(energy, false);
                        }
                    }
                };

                // Curios Slot
                if (curiosSlot !== "null") {
                    CuriosTrinketsUtil.getInstance()
                        .getItemsInSlot(entity, curiosSlot)
                        .forEach(modifyEnergy);
                }

                // Trinket Slot
                if (trinketSlot !== "null") {
                    CuriosTrinketsUtil.getInstance()
                        .getItemsInSlot(entity, trinketSlot)
                        .forEach(modifyEnergy);
                }

                // Armor and Hand Slots
                switch (slot) {
                    case "mainhand":
                        modifyEnergy(entity.getMainHandItem());
                        break;
                    case "offhand":
                        modifyEnergy(entity.getOffhandItem());
                        break;
                    case "head":
                    case "chest":
                    case "legs":
                    case "feet":
                        modifyEnergy(entity.getEquippedStack(Java.loadClass("net.minecraft.world.entity.EquipmentSlot")[armorSlotMap[slot]]));
                        break;
                }
            });
    });
})();
