(function () {
    let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');
    let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper');

    StartupEvents.registry('palladium:condition_serializer', (event) => {
        event.create('fsang:rf_minimum_condition')

            .addProperty('curios_slot', 'string', "null", 'Curios slot ID (set to "null" to skip)')
            .addProperty('trinket_slot', 'string', "null", 'Trinket slot ID (set to "null" to skip)')
            .addProperty('armor_or_hand_slot', 'string', "null", 'Armor or hand slot (mainhand, offhand, etc.)')
            .addProperty('min_rf', 'integer', 0, 'Minimum RF required')

            .test((entity, props) => {
                const curiosSlot = props.get('curios_slot') || "null";
                const trinketSlot = props.get('trinket_slot') || "null";
                const armorOrHandSlot = props.get('armor_or_hand_slot') || "null";
                const minRF = props.get('min_rf');

                function checkRF(item) {
                    if (item && !item.isEmpty()) {
                        let holderWrapper = EnergyHelper.getFromItemStack(item);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            return energyHolder.getEnergyStored() >= minRF;
                        }
                    }
                    return false;
                }

                // Check Curios slot
                if (curiosSlot.toLowerCase() !== "null") {
                    let curiosItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, curiosSlot.toLowerCase());
                    if (curiosItems.some(checkRF)) {
                        return true;
                    }
                }

                // Check Trinkets slot
                if (trinketSlot.toLowerCase() !== "null") {
                    let trinketItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, trinketSlot.toLowerCase());
                    if (trinketItems.some(checkRF)) {
                        return true;
                    }
                }

                // Check Armor or Hand slots
                if (armorOrHandSlot.toLowerCase() !== "null") {
                    let itemToCheck;
                    switch (armorOrHandSlot.toLowerCase()) {
                        case "mainhand":
                            itemToCheck = entity.getMainHandItem();
                            break;
                        case "offhand":
                            itemToCheck = entity.getOffhandItem();
                            break;
                        default:
                            return false; // Unsupported slot
                    }
                    return checkRF(itemToCheck);
                }

                return false;
            });
    });
})();
