let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('fsang:leap_scoreboard')
        .addProperty("scoreboard_name", "string", "leap_distance", "Scoreboard used for leap distance")

        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))

        .tick((entity, entry, holder, enabled) => {
            if (!enabled || !entity.isPlayer()) return;

            const scoreboardName = entry.getPropertyByName('scoreboard_name');
            const scoreboard = Utils.server.scoreboard;
            const sbObj = scoreboard.getObjective(scoreboardName);

            if (sbObj != null) {
                const playerName = entity.getGameProfile().getName();
                const score = scoreboard.getOrCreatePlayerScore(playerName, sbObj).getScore();

                let move = entity.getLookAngle().scale(score);
                entity.setDeltaMovement(move);

                if (entity.isPlayer()) {
                    entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
                }
            }
        });
});
