(function () {
    const ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

    StartupEvents.registry('palladium:abilities', (event) => {
        event.create('fsang:no_movement')
            .icon(palladium.createItemIcon('palladium:redstone_processor'))
            .addProperty('data_name', 'string', 'fsang_frozen', 'Persistent data used')
            .tick((entity, entry, holder, enabled) => {
                if (!enabled) return;

                const data_name = entry.getPropertyByName('data_name');
                entity.persistentData[data_name] = 1;

                // Fully stop motion
                entity.setMotion(0, 0, 0);
                entity.connection.send(new ClientboundSetEntityMotionPacket(entity));

                // Force teleport to current position (prevents WASD movement)
                const x = entity.getX();
                const y = entity.getY();
                const z = entity.getZ();
                entity.teleportTo(x, y, z);
            });
    });
})();
