(function () {
    StartupEvents.registry('palladium:abilities', event => {
        event.create('fsang:remove_power')
            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('exclude_namespace', 'string', 'fsang', 'The namespace to exclude from removal')
            .tick((entity, entry, holder, enabled) => {
                if (!enabled) return

                let blacklist = [
                    'namespace:power_name'
                ]
                let excludeNamespace = entry.getPropertyByName('exclude_namespace')
                let allPowers = palladium.powers.getPowerIds(entity).map(p => p.toString())
                let excludedPowers = palladium.powers.getPowerIdsForNamespace(entity, excludeNamespace).map(p => p.toString())

                allPowers.forEach(powerId => {
                    if (blacklist.indexOf(powerId) === -1 && excludedPowers.indexOf(powerId) === -1) {
                        palladium.superpowers.removeSuperpower(entity, powerId)

                    }
                })
            })
    })
})()