const MOVABLE_BLOCKS = [
    'minecraft:stone',
    'minecraft:cobblestone',
    'minecraft:dirt',
    'minecraft:dirt_path',
    'minecraft:grass_block',
    'minecraft:sand',
    'minecraft:red_sand',
    'minecraft:gravel',
    'minecraft:smooth_stone',
    'minecraft:end_stone',
    'minecraft:netherrack',
    'minecraft:deepslate',
    'minecraft:blackstone',
    'minecraft:sandstone',
    'minecraft:terracotta',
    'minecraft:andesite',
    'minecraft:andesite_slab',
    'minecraft:andesite_stairs',
    'minecraft:andesite_wall',
    'minecraft:basalt',
    'minecraft:black_terracotta',
    'minecraft:amethyst_block',
    'minecraft:coal_block',
    'minecraft:raw_copper_block',
    'minecraft:raw_iron_block',
    'minecraft:raw_gold_block',
    'minecraft:blue_terracotta',
    'minecraft:brown_terracotta',
    'minecraft:coal_ore',
    'minecraft:cobbled_deepslate',
    'minecraft:cobbled_deepslate_stairs',
    'minecraft:cobbled_deepslate_wall',
    'minecraft:cobblestone_stairs',
    'minecraft:cobblestone_wall',
    'minecraft:stone_stairs',
    'minecraft:stone_brick_wall',
    'minecraft:cyan_terracotta',
    'minecraft:deepslate',
    'minecraft:deepslate_coal_ore',
    'minecraft:deepslate_iron_ore',
    'minecraft:deepslate_copper_ore',
    'minecraft:deepslate_diamond_ore',
    'minecraft:deepslate_gold_ore',
    'minecraft:deepslate_redstone_ore',
    'minecraft:copper_ore',
    'minecraft:iron_ore',
    'minecraft:gold_ore',
    'minecraft:diamond_ore',
    'minecraft:emerald_ore',
    'minecraft:dripstone_block',
    'minecraft:granite',
    'minecraft:granite_stairs',
    'minecraft:granite_wall',
    'minecraft:gray_terracotta',
    'minecraft:green_terracotta',
    'minecraft:light_blue_terracotta',
    'minecraft:light_gray_terracotta',
    'minecraft:lime_terracotta',
    'minecraft:magenta_terracotta',
    'minecraft:magma_block',
    'minecraft:mossy_cobblestone',
    'minecraft:mud',
    'minecraft:mycelium',
    'minecraft:nether_gold_ore',
    'minecraft:orange_terracotta',
    'minecraft:packed_mud',
    'minecraft:pink_terracotta',
    'minecraft:podzol',
    'minecraft:purple_terracotta',
    'minecraft:red_terracotta',
    'minecraft:red_sandstone',
    'minecraft:red_sandstone_stairs',
    'minecraft:red_sandstone_wall',
    'minecraft:redstone_ore',
    'minecraft:rooted_dirt',
    'minecraft:sandstone_stairs',
    'minecraft:sandstone_wall',
    'minecraft:tuff',
    'minecraft:warped_nylium',
    'minecraft:white_terracotta',
    'minecraft:yellow_terracotta',
    'fsang:uru_ore',
    'fsang:adamantium_ore',
    'fsang:kryptonite_ore',
    'fsang:nth_ore',
    'palladium:lead_ore',
    'palladium:deepslate_lead_ore',
    'palladium:titanium_ore',
    'palladium:vibranium_ore',
    'palladium:redstone_flux_crystal_geode',
    'palladium:deepslate_redstone_flux_crystal_geode'

];

function isMovableBlock(id) {
    return MOVABLE_BLOCKS.indexOf(id) !== -1;
}

const FSANG_TLK_BLK = {
    PD_KEY: 'fsang.telekinesis_blocks.held_uuid',
    ZERO: '00000000-0000-0000-0000-000000000000',
    getHeldId(player) {
        let v = '';
        try { v = String(player.persistentData.getString(this.PD_KEY) || ''); } catch (_) { }
        if (!v || v.length < 36) {
            player.persistentData.putString(this.PD_KEY, this.ZERO);
            return this.ZERO;
        }
        return v;
    },
    setHeldId(player, uuidStr) {
        player.persistentData.putString(this.PD_KEY, (uuidStr && String(uuidStr).length >= 36) ? String(uuidStr) : this.ZERO);
    },
    _findEntityByUUIDString(level, uuidStr) {
        if (!uuidStr || uuidStr === this.ZERO) return null;
        const list = level.getEntities();
        for (let i = 0; i < list.size(); i++) {
            try { if (String(list.get(i).uuid) === uuidStr) return list.get(i); } catch (_) { }
        }
        return null;
    },
    getHeld(player) {
        const id = this.getHeldId(player);
        if (id === this.ZERO) return null;
        return this._findEntityByUUIDString(player.level, id);
    },
    setHeld(player, entityOrNull) {
        if (!entityOrNull) { this.setHeldId(player, this.ZERO); return; }
        try { this.setHeldId(player, String(entityOrNull.uuid)); } catch (_) { this.setHeldId(player, this.ZERO); }
    }
};

StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:geokinesis')
        .icon(palladium.createItemIcon('minecraft:lodestone'))
        .documentationDescription('Telekinesis Blocks: move only specific whitelisted blocks.')
        .addProperty('range_objective', 'string', 'FSang.Range', 'Scoreboard objective that defines geokinesis range.')
        .addProperty('strength', 'float', 0.8, 'The strength/speed of the geokinesis.')
        .addProperty('damage', 'float', 2, 'The damage to apply when hitting an entity with a block via geokinesis.')
        .addProperty('particles', 'string', 'minecraft:enchant', 'The particles to be applied around the block being held.')
        .firstTick((player, entry, holder, enabled) => {
            if (!enabled || !player || !player.isPlayer()) return;
            const range = getRangeFromScore_BLK(player, entry);
            const rayTrace = player.rayTrace(range, false);
            if (rayTrace.block != null && isMovableBlock(rayTrace.block.id)) {
                const spawned = spawnBlockDisplay_BLK(rayTrace.block);
                if (spawned) FSANG_TLK_BLK.setHeld(player, spawned);
            }
        })
        .tick((player, entry, holder, enabled) => {
            if (!enabled || !player || !player.isPlayer()) return;
            const range = getRangeFromScore_BLK(player, entry);
            let heldEntity = FSANG_TLK_BLK.getHeld(player);
            if (heldEntity == null) return;
            if (heldEntity.type != 'minecraft:block_display') { FSANG_TLK_BLK.setHeld(player, null); return; }
            let targetPos = player.getEyePosition().add(player.getLookAngle().scale(range));
            let hit = player.rayTrace(range).hit;
            if (hit) targetPos = hit;
            heldEntity.setPosition(targetPos.x() - 0.5, targetPos.y() - 0.5, targetPos.z() - 0.5);
            let boundingBox = AABB.ofSize(heldEntity.position(), 1, 1, 1);
            player.level.getEntities(heldEntity, boundingBox).forEach(e => {
                if (e.living) e.attack(entry.getPropertyByName('damage'));
            });
            let block = heldEntity.nbt && heldEntity.nbt.block_state ? heldEntity.nbt.block_state.Name : 'minecraft:air'
            player.level.sendParticles('minecraft:block ' + block, heldEntity.x, heldEntity.y, heldEntity.z, 1, 0.5, 0.5, 0.5, 0);
        })
        .lastTick((player, entry, holder, enabled) => {
            let heldEntity = FSANG_TLK_BLK.getHeld(player);
            if (heldEntity == null) return;
            if (heldEntity.type == 'minecraft:block_display') safePlaceBlockDisplay_BLK(heldEntity);
            FSANG_TLK_BLK.setHeld(player, null);
        });
});

function getRangeFromScore_BLK(entity, entry) {
    const objectiveName = entry.getPropertyByName('range_objective');
    let range = 0;
    try { range = palladium.scoreboard.getScore(entity, objectiveName, 0); } catch (_) { range = 0; }
    if (range <= 0) range = 1;
    return range;
}

function spawnBlockDisplay_BLK(block) {
    if (!isMovableBlock(block.id)) return null;
    let entity = block.level.createEntity('minecraft:block_display');
    entity.setPosition(block);
    entity.mergeNbt({ block_state: { Name: block.id, Properties: block.properties } });
    block.set('air');
    entity.spawn();
    return entity;
}

function safePlaceBlockDisplay_BLK(entity) {
    if (entity.type != 'minecraft:block_display') return;
    let target = entity.block;
    if (target.id !== 'minecraft:air') {
        target.level.destroyBlock(target.pos, true);
    }
    let props = {};
    if (entity.nbt.block_state.Properties != null) {
        for (let [key, value] of Object.entries(entity.nbt.block_state.Properties)) {
            props[key] = value;
        }
    }
    target.set(entity.nbt.block_state.Name, props);
    target.level.markAndNotifyBlock(
        target.pos,
        target.level.getChunk(target.pos),
        target.blockState,
        target.blockState,
        3,
        512
    );
    entity.discard();
}
