function rayTrace(entity, distance) {
    let eyePos = entity.getEyePosition(1);
    let viewVec = entity.motionDirection.normal;

    let endVec = eyePos.add(viewVec.x * distance, viewVec.y * distance, viewVec.z * distance);
    return entity.level.clip(new ClipContext(eyePos, endVec, "outline", "none", entity));
}

(function () {
    StartupEvents.registry('palladium:abilities', (event) => {

        event.create('fsang:teleportation')

            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('teleportation_distance', 'float', 10, 'the max distance to allow the player to teleport to.')

            .tick((entity, entry, holder, enabled) => {
                if (enabled) {
                    let teleportation_distance = entry.getPropertyByName('teleportation_distance');
                    let data_name = entry.getPropertyByName('data_name');
                    entity.persistentData[data_name] = 0;

                    let raytrace_block = rayTrace(entity, teleportation_distance);
                    if (raytrace_block && raytrace_block.blockPos) {
                        let hitPos = raytrace_block.blockPos;
                        entity.setPosition(hitPos.getX() - 0.35, hitPos.getY() + 0.0, hitPos.getZ() - 0.35);

                        // Adjust this if needed to fit the teleportation exactly at the hit position
                    }
                }
            });
    });
})();
