// File: kubejs/server_scripts/fsang/asgardian_from_uru_apple.js

// Add/adjust entries freely. Each entry controls its own roll weight and display name.
const possibleAsgardianPowers = [
    { id: 'fsang:asgardian', weight: 1, displayName: 'Asgardian (Royal)' },
    { id: 'fsang:asgardian2', weight: 1, displayName: 'Asgardian (Gatekeeper)' }
    // Example: { id: 'fsang:asgardian3', weight: 2, displayName: 'Asgardian (III)' }
];

// Weighted choice helper
function choosePowerEntry() {
    const total = possibleAsgardianPowers.reduce((s, p) => s + p.weight, 0);
    let r = Math.random() * total;
    for (const p of possibleAsgardianPowers) {
        if (r < p.weight) return p;
        r -= p.weight;
    }
    return possibleAsgardianPowers[0]; // fallback
}

ItemEvents.foodEaten(event => {
    const { player, item, server } = event;
    if (!server) return;

    if (item.id !== 'fsang:uru_apple') return;

    const rolled = choosePowerEntry();

    server.runCommandSilent(`execute as ${player.name.string} run superpower remove fsang:all`);
    superpowerUtil.addSuperpower(player, rolled.id);
    player.tell(`§6The ancient magic stirs in your veins. §e${rolled.displayName} §6awakened.`);
});
