const supesWeights = [
    { power: "fsang:homelander", weight: 4, name: "Homelander" }
];

function getRandomSupePower() {
    const totalWeight = supesWeights.reduce((acc, mutation) => acc + mutation.weight, 0);
    let random = Math.random() * totalWeight;

    for (const mutation of supesWeights) {
        if (random < mutation.weight) {
            return mutation;
        }
        random -= mutation.weight;
    }
}
function getRandomScore(min, max) {
    return Math.floor(Math.random() * (max - min + 1)) + min;
}

ItemEvents.rightClicked(event => {
    const { hand, player, server, player: { username, mainHandItem, offhandItem } } = event;

    if (mainHandItem.id == "fsang:compound_v") {
        const selectedPower2 = getRandomSupePower(supesWeights.power);
        player.setItemInHand(hand, "minecraft:air")

        server.runCommandSilent(`execute as ${username} run superpower remove fsang:all`);

        superpowerUtil.addSuperpower(player, selectedPower2.power);
        player.tell(`You have been granted the Supe Variant: ${selectedPower2.name}`);
    }
});
