BlockEvents.rightClicked('fsang:rf_charger', event => {
    const player = event.player;
    const main = player.mainHandItem;
    const off = player.offHandItem;
    const server = event.server;

    const validFuel = ['minecraft:coal', 'minecraft:charcoal'];

    // Prevent re-use during cooldown
    if (player.stages.has("FSang.Cooldown.RFCharger")) {
        player.tell("§7Recharging... please wait.");
        return;
    }

    if (!validFuel.includes(main.id)) {
        player.tell("§cHold valid fuel in your main hand.");
        return;
    }

    if (off.empty) {
        player.tell("§cHold the item to charge in your offhand.");
        return;
    }

    // Apply cooldown stage and charging tag
    player.stages.add("FSang.Cooldown.RFCharger");
    player.addTag("FSang.Charging");
    player.tell(`§aCharging started with ${main.id.replace("minecraft:", "")}...`);

    // Remove both after 20 ticks
    server.scheduleInTicks(20, () => {
        player.stages.remove("FSang.Cooldown.RFCharger");
        player.removeTag("FSang.Charging");
        player.tell("§7Charging complete.");
    });

    // Consume fuel
    if (main.count > 1) {
        main.count -= 1;
    } else {
        player.setItemInHand("main_hand", Item.empty);
    }
});
