// kubejs/server_scripts/fsang_iron_stand_71.js
BlockEvents.rightClicked(event => {
    const p = event.player
    if (!p) return
    if (!event.block) return
    if (event.hand !== 'MAIN_HAND') return
    if (!event.item || event.item.id !== 'fsang:iron_man_model_71_summon') return

    const pos = event.block.pos.above()
    const sx = pos.x + 0.5, sy = pos.y + 0.0, sz = pos.z + 0.5

    const dx = p.x - sx, dz = p.z - sz
    let yaw = -Math.atan2(dx, dz) * 180 / Math.PI
    yaw = ((yaw % 360) + 360) % 360
    const rot = yaw.toFixed(1)

    // 1) summon in the correct dimension
    event.level.runCommandSilent(
        `execute positioned ${sx.toFixed(3)} ${sy.toFixed(3)} ${sz.toFixed(3)} run summon minecraft:armor_stand ~ ~ ~ {Invisible:1b,PersistenceRequired:1b,Tags:["FSang.IronStand71","FSang.IronStand71_New"],ArmorItems:[{},{},{id:"fsang:iron_man_model_71_chestplate",Count:1b},{}]}`
    )

    // 2) next tick, lock its facing via Rotation + Pose (target the newest, nearest tagged stand)
    event.server.scheduleInTicks(1, () => {
        event.level.runCommandSilent(
            `execute at @e[type=minecraft:armor_stand,tag=FSang.IronStand71_New,limit=1,sort=nearest,distance=..1] run data merge entity @s {Rotation:[${rot}f,0f],Pose:{Body:[0f,${rot}f,0f],Head:[0f,${rot}f,0f]}}`
        )
        event.level.runCommandSilent(
            `tag @e[type=minecraft:armor_stand,tag=FSang.IronStand71_New,limit=1,sort=nearest] remove FSang.IronStand71_New`
        )
    })

    event.item.count--
    event.cancel()
})
