const SYMBIOTE_COOLDOWN_TIME = 300; // Cooldown time in seconds
const symbioteCooldowns = {}; // Object to store player cooldowns
const playerSymbioteAssigner = {}; // To store the Symbiote_Assigner value for each player
const targetPlayer2 = ".sang"; // Target player name for scoreboard checks

ItemEvents.rightClicked(e => {
    const { hand, player, server, player: { username, mainHandItem, offhandItem } } = e;
    const itemId = mainHandItem.id;
    let power_amount = superpowerUtil.getSuperpowers(player).length;

    // Define the symbiote items with corresponding Symbiote_Assigner values
    const symbioteItems = {
        "fsang:symbiote_venom_dna": 1,
        "fsang:symbiote_carnage_dna": 2,
        "fsang:symbiote_riot_dna": 3,
        "fsang:symbiote_agony_dna": 4,
        "fsang:symbiote_lasher_dna": 5,
        "fsang:symbiote_phage_dna": 6,
        "fsang:symbiote_toxin_dna": 7,
        "fsang:symbiote_scorn_dna": 8,
        "fsang:symbiote_scream_dna": 9,
        "fsang:symbiote_sleeper_dna": 10,
        "fsang:symbiote_host_rider_dna": 11,
        "fsang:symbiote_fang_dna": 12,
        "fsang:symbiote_misery_dna": 13,
        "fsang:symbiote_hybrid_dna": 14,
        "fsang:symbiote_grendel_dna": 15,
        "fsang:symbiote_curse_dna": 16,
        "fsang:symbiote_death_angel_dna": 17,
        "fsang:symbiote_strain_dna": 18,
        "fsang:symbiote_thorn_dna": 19,
        "fsang:symbiote_reaper_dna": 20,
        "fsang:symbiote_blackout_dna": 21,
        "fsang:symbiote_authority_dna": 22,
        "fsang:symbiote_bloom_dna": 23,
        "fsang:symbiote_inumis_dna": 24,
        "fsang:symbiote_montechiari_dna": 25,
        "fsang:symbiote_sprain_dna": 26,
        "fsang:symbiote_tempest_dna": 27,
        "fsang:symbiote_aquamarine_dna": 28,
        "fsang:symbiote_xenocive_dna": 29,
        "fsang:symbiote_wraith_dna": 98,
        "fsang:symbiote_fallout_dna": 99,
        "fsang:symbiote_creator_dna": 100
    };

    const symbioteArtificialItems = {
        "fsang:symbiote_artificial_venom_dna": 1,
        "fsang:symbiote_artificial_carnage_dna": 2,
        "fsang:symbiote_artificial_riot_dna": 3,
        "fsang:symbiote_artificial_agony_dna": 4,
        "fsang:symbiote_artificial_lasher_dna": 5,
        "fsang:symbiote_artificial_phage_dna": 6,
        "fsang:symbiote_artificial_toxin_dna": 7,
        "fsang:symbiote_artificial_scorn_dna": 8,
        "fsang:symbiote_artificial_scream_dna": 9,
        "fsang:symbiote_artificial_sleeper_dna": 10,
    };

    // Get the scoreboard value of the player '.sang' for "FSang.Gamerule.symbiote"
    const scoreboardValue = server.runCommandSilent(`scoreboard players get ${targetPlayer2} FSang.Gamerule.symbiote`);

    // Handle cooldown logic
    if (symbioteCooldowns[username] && symbioteCooldowns[username] > Date.now()) {
        if (scoreboardValue === 0) {
            // Reset cooldown to 0 if the scoreboard is changed to 0
            symbioteCooldowns[username] = 0;
            server.runCommandSilent(`title ${username} actionbar {"text":"Cooldown removed due to scoreboard change","color":"green"}`);
        } else {
            // Show the remaining cooldown time
            const remainingTime = Math.ceil((symbioteCooldowns[username] - Date.now()) / 1000);
            const minutes = Math.floor(remainingTime / 60);
            const seconds = remainingTime % 60;
            server.runCommandSilent(`title ${username} actionbar {"text":"Cooldown: ${minutes}m ${seconds}s","color":"red"}`);
            return; // Prevent further action if on cooldown
        }
    }

    // Handle storing a symbiote (empty symbiote logic)
    if (mainHandItem.id === "fsang:symbiote_empty_dna" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang_secondary:symbiote_natural')) {
        const assignerValue = playerSymbioteAssigner[username] || 0;

        // Replace based on the current Symbiote_Assigner score

        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=1}] weapon.mainhand with fsang:symbiote_venom_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=2}] weapon.mainhand with fsang:symbiote_carnage_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=3}] weapon.mainhand with fsang:symbiote_riot_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=4}] weapon.mainhand with fsang:symbiote_agony_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=5}] weapon.mainhand with fsang:symbiote_lasher_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=6}] weapon.mainhand with fsang:symbiote_phage_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=7}] weapon.mainhand with fsang:symbiote_toxin_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=8}] weapon.mainhand with fsang:symbiote_scorn_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=9}] weapon.mainhand with fsang:symbiote_scream_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=10}] weapon.mainhand with fsang:symbiote_sleeper_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=11}] weapon.mainhand with fsang:symbiote_host_rider_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=12}] weapon.mainhand with fsang:symbiote_fang_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=13}] weapon.mainhand with fsang:symbiote_misery_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=14}] weapon.mainhand with fsang:symbiote_hybrid_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=15}] weapon.mainhand with fsang:symbiote_grendel_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=16}] weapon.mainhand with fsang:symbiote_curse_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=17}] weapon.mainhand with fsang:symbiote_death_angel_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=18}] weapon.mainhand with fsang:symbiote_strain_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=19}] weapon.mainhand with fsang:symbiote_thorn_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=20}] weapon.mainhand with fsang:symbiote_reaper_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=21}] weapon.mainhand with fsang:symbiote_blackout_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=22}] weapon.mainhand with fsang:symbiote_authority_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=23}] weapon.mainhand with fsang:symbiote_bloom_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=24}] weapon.mainhand with fsang:symbiote_inumis_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=25}] weapon.mainhand with fsang:symbiote_montechiari_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=26}] weapon.mainhand with fsang:symbiote_sprain_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=27}] weapon.mainhand with fsang:symbiote_tempest_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=28}] weapon.mainhand with fsang:symbiote_aquamarine_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=29}] weapon.mainhand with fsang:symbiote_xenocive_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=98}] weapon.mainhand with fsang:symbiote_wraith_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=99}] weapon.mainhand with fsang:symbiote_fallout_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[name=FSang18,scores={Symbiote_Assigner=100}] weapon.mainhand with fsang:symbiote_creator_dna`);

        // Remove symbiote power after switching the item
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age.Symbiote 0`);
        superpowerUtil.removeSuperpower(player, 'fsang_secondary:symbiote_natural');
    }

    // Handle intake of a symbiote (filled symbiote logic)
    else if (itemId in symbioteItems) {
        const assigner = symbioteItems[itemId];
        playerSymbioteAssigner[username] = assigner; // Store the Symbiote_Assigner for this player

        server.runCommandSilent("scoreboard objectives add Symbiote_Assigner dummy");
        // Set the Symbiote_Assigner score
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_venom_dna\"}}] Symbiote_Assigner 1`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_carnage_dna\"}}] Symbiote_Assigner 2`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_riot_dna\"}}] Symbiote_Assigner 3`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_agony_dna\"}}] Symbiote_Assigner 4`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_lasher_dna\"}}] Symbiote_Assigner 5`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_phage_dna\"}}] Symbiote_Assigner 6`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_toxin_dna\"}}] Symbiote_Assigner 7`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_scorn_dna\"}}] Symbiote_Assigner 8`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_scream_dna\"}}] Symbiote_Assigner 9`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_sleeper_dna\"}}] Symbiote_Assigner 10`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_host_rider_dna\"}}] Symbiote_Assigner 11`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_fang_dna\"}}] Symbiote_Assigner 12`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_misery_dna\"}}] Symbiote_Assigner 13`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_hybrid_dna\"}}] Symbiote_Assigner 14`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_grendel_dna\"}}] Symbiote_Assigner 15`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_curse_dna\"}}] Symbiote_Assigner 16`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_death_angel_dna\"}}] Symbiote_Assigner 17`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_strain_dna\"}}] Symbiote_Assigner 18`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_thorn_dna\"}}] Symbiote_Assigner 19`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_reaper_dna\"}}] Symbiote_Assigner 20`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_blackout_dna\"}}] Symbiote_Assigner 21`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_authority_dna\"}}] Symbiote_Assigner 22`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_bloom_dna\"}}] Symbiote_Assigner 23`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_inumis_dna\"}}] Symbiote_Assigner 24`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_montechiari_dna\"}}] Symbiote_Assigner 25`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_sprain_dna\"}}] Symbiote_Assigner 26`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_tempest_dna\"}}] Symbiote_Assigner 27`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_aquamarine_dna\"}}] Symbiote_Assigner 28`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_xenocive_dna\"}}] Symbiote_Assigner 29`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_wraith_dna\"}}] Symbiote_Assigner 98`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_fallout_dna\"}}] Symbiote_Assigner 99`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[name=FSang18,nbt={SelectedItem:{id:\"fsang:symbiote_creator_dna\"}}] Symbiote_Assigner 100`);
        // Add the symbiote power
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s FSang.Age.Symbiote 0`);
        superpowerUtil.addSuperpower(player, 'fsang_secondary:symbiote_natural');
        player.setItemInHand(hand, "fsang:symbiote_empty_dna"); // Change back to empty symbiote
    }

    // Handle storing a symbiote (empty symbiote logic)
    else if (mainHandItem.id === "fsang:symbiote_empty_dna" && offhandItem.id == "minecraft:air" && superpowerUtil.hasSuperpower(e.player, 'fsang_secondary:symbiote')) {
        const assignerValue = playerSymbioteAssigner[username] || 0;

        // Replace based on the current Symbiote_Assigner score

        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=1}] weapon.mainhand with fsang:symbiote_artificial_venom_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=2}] weapon.mainhand with fsang:symbiote_artificial_carnage_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=3}] weapon.mainhand with fsang:symbiote_artificial_riot_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=4}] weapon.mainhand with fsang:symbiote_artificial_agony_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=5}] weapon.mainhand with fsang:symbiote_artificial_lasher_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=6}] weapon.mainhand with fsang:symbiote_artificial_phage_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=7}] weapon.mainhand with fsang:symbiote_artificial_toxin_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=8}] weapon.mainhand with fsang:symbiote_artificial_scorn_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=9}] weapon.mainhand with fsang:symbiote_artificial_scream_dna`);
        server.runCommandSilent(`execute as ${username} run item replace entity @s[scores={Symbiote_Assigner=10}] weapon.mainhand with fsang:symbiote_artificial_sleeper_dna`);

        // Remove symbiote power after switching the item
        superpowerUtil.removeSuperpower(player, 'fsang_secondary:symbiote');
    }

    // Handle intake of a symbiote (filled symbiote logic)
    else if (itemId in symbioteArtificialItems) {
        const assigner = symbioteArtificialItems[itemId];
        playerSymbioteAssigner[username] = assigner; // Store the Symbiote_Assigner for this player

        server.runCommandSilent("scoreboard objectives add Symbiote_Assigner dummy");
        // Set the Symbiote_Assigner score
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_venom_dna\"}}] Symbiote_Assigner 1`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_carnage_dna\"}}] Symbiote_Assigner 2`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_riot_dna\"}}] Symbiote_Assigner 3`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_agony_dna\"}}] Symbiote_Assigner 4`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_lasher_dna\"}}] Symbiote_Assigner 5`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_phage_dna\"}}] Symbiote_Assigner 6`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_toxin_dna\"}}] Symbiote_Assigner 7`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_scorn_dna\"}}] Symbiote_Assigner 8`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_scream_dna\"}}] Symbiote_Assigner 9`);
        server.runCommandSilent(`execute as ${username} run scoreboard players set @s[nbt={SelectedItem:{id:\"fsang:symbiote_artificial_sleeper_dna\"}}] Symbiote_Assigner 10`);
        // Add the symbiote power
        superpowerUtil.addSuperpower(player, 'fsang_secondary:symbiote');
        player.setItemInHand(hand, "fsang:symbiote_empty_dna"); // Change back to empty symbiote
    }

    // Set the cooldown after the item is used
    if (itemId in symbioteItems || mainHandItem.id === "fsang:symbiote_empty_dna") {
        if (scoreboardValue === 1) {
            symbioteCooldowns[username] = Date.now() + SYMBIOTE_COOLDOWN_TIME * 1000; // Set the 300 seconds cooldown
        } else {
            symbioteCooldowns[username] = 0; // No cooldown
        }
    }
});
