StartupEvents.registry('palladium:abilities', (event) => {
    event.create('fsang:multimotion')
        .addProperty('distance', 'integer', 10, 'the distance the blackhole can pull things from')
        .addProperty('pull_speed', 'integer', 1, 'the speed at which the blackhole pulls things in')
        .firstTick((entity, entry, holder, enabled) => {
            let distance = entry.getPropertyByName('distance')
            let pull_speed = entry.getPropertyByName('pull_speed')
            if (enabled) {
                let targets = entity.level.getEntities(entity, entity.boundingBox.inflate(distance))
                for (let target of targets) {
                    if (target !== entity) {
                        let direction = entity.position().subtract(target.position())
                        let motion = direction.normalize().scale(pull_speed)
                        target.setDeltaMovement(motion)
                        if (target.isPlayer()) {
                            let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
                            target.connection.send(new ClientboundSetEntityMotionPacket(target));
                        }
                    }
                }
            }
        })
})
//Made by ShadowLegacy557