StartupEvents.registry('palladium:condition_serializer', (event) => {
    event.create('fsang:block_search')
        .addProperty('block_id', 'string', 'minecraft:stone', 'ID of the block to search for')
        .addProperty('search_radius', 'float', 10, 'Radius within which to search for the block')

        .test((entity, props) => {
            const world = entity.level;
            const blockId = `block.${props.get('block_id').replace(':', '.')}`;
            const radius = props.get('search_radius');
            const radiusSquared = radius * radius;

            let entityPos = entity.blockPosition();

            for (let x = -radius; x <= radius; x++) {
                for (let y = -radius; y <= radius; y++) {
                    for (let z = -radius; z <= radius; z++) {
                        if (x * x + y * y + z * z > radiusSquared) continue; // Skip blocks outside the sphere

                        let blockPos = entityPos.offset(x, y, z);
                        if (world.getBlockState(blockPos).getBlock().getDescriptionId() === blockId) {
                            return true; // Exit early when found
                        }
                    }
                }
            }

            return false;
        });
});