(function () {
  let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');

  // Register the custom condition
  StartupEvents.registry('palladium:condition_serializer', (event) => {
      event.create('fsang:has_item_in_curios_trinkets')

          // Define properties
          .addProperty('curios_slot', 'string', "null", 'Curios slot ID (set to "null" to skip)')
          .addProperty('trinket_slot', 'string', "null", 'Trinket slot ID (set to "null" to skip)')
          .addProperty('item_id', 'string', 'minecraft:diamond', 'ID of the item to check for')

          .test((entity, props) => {
              const curios_slot = props.get('curios_slot') || "null";
              const trinket_slot = props.get('trinket_slot') || "null";
              const itemId = props.get('item_id');

              // Helper function to check if the item matches
              function checkItemInSlot(item) {
                  return item && !item.isEmpty() && item.getItem().getDescriptionId() === `item.${itemId.replace(':', '.')}`;
              }

              // Check Curios slot if specified
              if (curios_slot.toLowerCase() !== "null") {
                  let curiosItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, curios_slot.toLowerCase());
                  for (let item of curiosItems) {
                      if (checkItemInSlot(item)) {
                          return true; // Item found in Curios slot
                      }
                  }
              }

              // Check Trinkets slot if specified
              if (trinket_slot.toLowerCase() !== "null") {
                  let trinketItems = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, trinket_slot.toLowerCase());
                  for (let item of trinketItems) {
                      if (checkItemInSlot(item)) {
                          return true; // Item found in Trinket slot
                      }
                  }
              }

              return false; // Item not found in any slot
          });
  });
})();
