//Made by FSang18

var IMMOVABLE_BLOCKS_EQ = [
    'minecraft:bedrock', 'minecraft:barrier', 'minecraft:end_portal', 'minecraft:end_gateway', 'minecraft:end_portal_frame',
    'minecraft:nether_portal', 'minecraft:command_block', 'minecraft:repeating_command_block', 'minecraft:chain_command_block',
    'minecraft:structure_block', 'minecraft:jigsaw', 'minecraft:spawner', 'minecraft:reinforced_deepslate',
    'minecraft:chest', 'minecraft:trapped_chest', 'minecraft:ender_chest', 'minecraft:barrel', 'minecraft:beacon',
    'minecraft:enchanting_table', 'minecraft:respawn_anchor', 'minecraft:lodestone', 'minecraft:dragon_egg', 'minecraft:conduit'
];

function isShulkerBoxEq(id) { return id.endsWith('_shulker_box') || id === 'minecraft:shulker_box' }
function isUnreplaceableEq(id) { return isShulkerBoxEq(id) || IMMOVABLE_BLOCKS_EQ.indexOf(id) !== -1 }

function topSolidYEq(level, baseY, x, z) {
    var y = Math.floor(baseY) - 1;
    for (var dy = 4; dy >= -6; dy--) {
        var checkY = y + dy;
        var b = level.getBlock(x, checkY, z);
        if (b && b.getId() !== 'minecraft:air') return checkY;
    }
    return y;
}

function storeBlocksEq(player, list) {
    player.persistentData.putString('fsang.earthquake.blocks', JSON.stringify(list));
}
function loadBlocksEq(player) {
    var s = '';
    try { s = String(player.persistentData.getString('fsang.earthquake.blocks') || '') } catch (_) { }
    if (!s) return [];
    try { return JSON.parse(s) } catch (_) { return [] }
}
function clearStoreEq(player) {
    player.persistentData.putString('fsang.earthquake.blocks', '');
    player.persistentData.putBoolean('fsang.earthquake.active', false);
}

function fmt3(n) { return String(Math.round(n * 1000) / 1000) }

function summonFallingEq(entity, x, y, z, id, motionY, lateral) {
    var mx = (Math.random() - 0.5) * lateral;
    var mz = (Math.random() - 0.5) * lateral;
    entity.runCommandSilent('summon falling_block ' + x + ' ' + y + ' ' + z + ' {Time:1,DropItem:0b,Tags:["fsang_earthquake"],Motion:[' + fmt3(mx) + 'd,' + fmt3(motionY) + 'd,' + fmt3(mz) + 'd],BlockState:{Name:"' + id + '"}}');
}

StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:earthquake')
        .icon(palladium.createItemIcon('minecraft:lodestone'))
        .documentationDescription('Shake loose nearby ground blocks into the air with an outward delay, then restore them.')
        .addProperty('range', 'integer', 6, 'Radius around player to affect')
        .addProperty('ring_delay', 'integer', 2, 'Ticks to delay per distance ring')
        .addProperty('duration_ticks', 'integer', 60, 'Duration before restoration')
        .addProperty('max_blocks', 'integer', 200, 'Hard cap of affected blocks per activation')
        .addProperty('scan_density', 'float', 1.0, 'Grid step size in blocks (1.0=every block)')
        .addProperty('vertical_boost', 'float', 0.65, 'Upward velocity of falling blocks')
        .addProperty('lateral_jitter', 'float', 0.18, 'Sideways jitter for falling blocks')
        .firstTick((player, entry, holder, enabled) => {
            if (!(enabled)) return;
            if (player.persistentData.getBoolean('fsang.earthquake.active')) return;
            var level = player.level;
            var server = player.server;
            var range = Math.max(1, entry.getPropertyByName('range'));
            var ringDelay = Math.max(0, entry.getPropertyByName('ring_delay'));
            var step = Math.max(0.5, entry.getPropertyByName('scan_density'));
            var maxBlocks = Math.max(1, entry.getPropertyByName('max_blocks'));
            var boost = entry.getPropertyByName('vertical_boost');
            var jitter = entry.getPropertyByName('lateral_jitter');
            var list = [];
            var rings = {};
            var baseY = player.y;
            var px = Math.floor(player.x);
            var pyUnder = Math.floor(player.y) - 1;
            var pz = Math.floor(player.z);
            var count = 0;
            outer: for (var dx = -range; dx <= range; dx += step) {
                for (var dz = -range; dz <= range; dz += step) {
                    if (count >= maxBlocks) break outer;
                    var gx = Math.floor(px + dx);
                    var gz = Math.floor(pz + dz);
                    var r2 = dx * dx + dz * dz;
                    if (r2 > range * range) continue;
                    var gy = topSolidYEq(level, baseY, gx, gz);
                    if (gx === px && gz === pz && gy === pyUnder) continue;
                    var block = level.getBlock(gx, gy, gz);
                    var id = block.getId();
                    if (id === 'minecraft:air') continue;
                    if (isUnreplaceableEq(id)) continue;
                    var props = {};
                    try {
                        var p = block.properties || {};
                        for (var k in p) { props[k] = p[k] }
                    } catch (_) { }
                    list.push({ x: gx, y: gy, z: gz, id: id, props: props });
                    var dist = Math.sqrt(r2);
                    var ring = Math.max(0, Math.floor(dist));
                    if (!rings[ring]) rings[ring] = [];
                    rings[ring].push({ x: gx, y: gy, z: gz, id: id });
                    count++;
                }
            }
            storeBlocksEq(player, list);
            player.persistentData.putBoolean('fsang.earthquake.active', true);
            var ringKeys = [];
            for (var rk in rings) { ringKeys.push(parseInt(rk, 10)) }
            ringKeys.sort(function (a, b) { return a - b });
            for (var i = 0; i < ringKeys.length; i++) {
                (function (delayTicks, batch) {
                    server.scheduleInTicks(delayTicks, function () {
                        for (var j = 0; j < batch.length; j++) {
                            var it = batch[j];
                            var b = level.getBlock(it.x, it.y, it.z);
                            if (b.getId() === 'minecraft:air') continue;
                            b.set('minecraft:air');
                            summonFallingEq(player, it.x, it.y, it.z, it.id, boost, jitter);
                        }
                    });
                })(ringKeys[i] * ringDelay, rings[ringKeys[i]]);
            }
        })
        .tick((player, entry, holder, enabled) => {
            if (!(enabled && player && player.isPlayer())) return;
            if (!player.persistentData.getBoolean('fsang.earthquake.active')) return;

        })
        .lastTick((player, entry, holder, enabled) => {
            var level = player.level;
            var stored = loadBlocksEq(player);
            if (stored.length === 0) { clearStoreEq(player); return }
            try {
                level.runCommandSilent('kill @e[type=falling_block,tag=fsang_earthquake,distance=..64]');
                for (var i = 0; i < stored.length; i++) {
                    var it = stored[i];
                    var b = level.getBlock(it.x, it.y, it.z);
                    var props = it.props || {};
                    b.set(it.id, props);
                    try { level.markAndNotifyBlock(b.pos, level.getChunk(b.pos), b.blockState, b.blockState, 3, 512) } catch (_) { }
                }
            } catch (_) { }
            clearStoreEq(player);
        });
});
