(function(){
    let CuriosTrinketsUtil = Java.loadClass('net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil');
    let EnergyHelper = Java.loadClass('net.threetag.palladium.energy.EnergyHelper');

    StartupEvents.registry('palladium:condition_serializer', (event) => {

        event.create('fsang:get_energy')
        
        .addProperty('energy', 'integer', 10, 'Amount of energy to compare')
        .addProperty('id', 'string', "fsang:arc_reactor", 'Item to look for')
        .addProperty('curios_slot', 'string', null, 'Curios slot id, default null')
        .addProperty('trinket_slot', 'string', null, 'Trinket slot id, default null')
        .addProperty('slot_type', 'string', null, 'Slot to check: "mainhand", "offhand", "inventory", or null by default')

        .test((entity, props) => {
            let energycompare = props.get("energy");
            let id = props.get("id");

            // Check curios/trinket slots if they are not null
            if (props.get("curios_slot") !== null || props.get("trinket_slot") !== null) {
                let curios_slot = props.get("curios_slot");
                let trinket_slot = props.get("trinket_slot");

                let items = CuriosTrinketsUtil.getInstance().getItemsInSlot(entity, Platform.isForge() ? curios_slot : trinket_slot);

                for (let i = 0; i < items.length; i++) {
                    let item = items[i];
                    if (item.id === id) {
                        let holderWrapper = EnergyHelper.getFromItemStack(item);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            if (energyHolder.getEnergyAmount() >= energycompare) {
                                return true;
                            }
                        }
                    }
                }
            }

            // Check based on the slot_type property
            let slotType = props.get("slot_type");

            // Only proceed with inventory checks if the entity is a player (or an entity with inventory) and slot_type is not null
            if (slotType !== null && entity.isPlayer()) {
                if (slotType === "mainhand") {
                    let mainhandItem = entity.getMainHandItem();
                    if (mainhandItem.id === id) {
                        let holderWrapper = EnergyHelper.getFromItemStack(mainhandItem);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            if (energyHolder.getEnergyAmount() >= energycompare) {
                                return true;
                            }
                        }
                    }
                } else if (slotType === "offhand") {
                    let offhandItem = entity.getOffHandItem();
                    if (offhandItem.id === id) {
                        let holderWrapper = EnergyHelper.getFromItemStack(offhandItem);
                        if (holderWrapper.isPresent()) {
                            let energyHolder = holderWrapper.get();
                            if (energyHolder.getEnergyAmount() >= energycompare) {
                                return true;
                            }
                        }
                    }
                } else if (slotType === "inventory") {
                    let inventoryItems = entity.getInventory().items; 
                    for (let i = 0; i < inventoryItems.length; i++) {
                        let item = inventoryItems[i];
                        if (item.id === id) {
                            let holderWrapper = EnergyHelper.getFromItemStack(item);
                            if (holderWrapper.isPresent()) {
                                let energyHolder = holderWrapper.get();
                                if (energyHolder.getEnergyAmount() >= energycompare) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }

            return false;
        });
    });
})();
