(function () {
    StartupEvents.registry('palladium:abilities', event => {
        event.create('fsang:ability_list')
            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('range', 'float', 10.0, 'The range within which the effect will be granted')

            .tick((entity, entry, holder, enabled) => {
                if (!enabled) return;

                let range = entry.getPropertyByName('range');
                let target = entity.rayTrace(range).entity;

                let blacklist = [
                    'fsang:absolute_superman_suit',
                    'fsang:age',
                    'fsang:apocalypse_gift',
                    'fsang:asgardian_effect',
                    'fsang:batman_beyond_suit',
                    'fsang:batman_tools',
                    'fsang:capes',
                    'fsang:charged_tools',
                    'fsang_hero:dampened',
                    'fsang:decay_effect',
                    'fsang:energy_weapons',
                    'fsang:fabricator',
                    'fsang:freeze_effect',
                    'fsang:gamma_radiation',
                    'fsang:grant_x_gene',
                    'fsang:hellfire_weapons',
                    'fsang:hive_removal',
                    'fsang:ice_weapons',
                    'fsang:inhibitor_collar',
                    'fsang:inhibitor_collar_attempt',
                    'fsang:inhibitor_collar_attempt2',
                    'fsang:inhibitor_collar_attempt3',
                    'fsang:inhibitor_collar_attempt4',
                    'fsang:iron_man',
                    'fsang:iron_man_ai_chip',
                    'fsang:iron_man_model_1',
                    'fsang:iron_man_model_2',
                    'fsang:iron_man_model_3',
                    'fsang:iron_man_model_4',
                    'fsang:iron_man_model_71',
                    'fsang:iron_man_shield',
                    'fsang:iron_man_suits',
                    'fsang:kryptonite_weapons',
                    'fsang:magnetic_hold',
                    'fsang:magnetism_effect',
                    'fsang:magneto_helmet',
                    'fsang:mindless_attack',
                    'fsang:negative_speedforce_chem',
                    'fsang:phasing_effect',
                    'fsang:phoenix_healing',
                    'fsang:picotech_suit',
                    'fsang:power_reset',
                    'fsang:power_supression',
                    'fsang:psychic_damage',
                    'fsang:reality_warping_remove_power',
                    'fsang:shazam_staff',
                    'fsang:shock_effect',
                    'fsang:slow_time_effect',
                    'fsang:sonic_gun',
                    'fsang:sound_effect',
                    'fsang:space_power',
                    'fsang:speed_transfer_effect',
                    'fsang:speedster_chem',
                    'fsang:spawn_gift',
                    'fsang:speedforce_changer',
                    'fsang:spider_serum',
                    'fsang:superman_black_solar',
                    'fsang:symbiote_enhancement',
                    'fsang:symbiote_sickness',
                    'fsang:tachyon_device',
                    'fsang:tachyon_reactor',
                    'fsang:tactile_telekinesis_stun',
                    'fsang:telekinetic_hold',
                    'fsang:telepathy_motion',
                    'fsang:time_effect',
                    'fsang:uncontrollable_movement',
                    'fsang:uru_apple',
                    'fsang:utility_belt',
                    'fsang:vibranium_shield',
                    'fsang:web_armor',
                    'fsang:web_bat',
                    'fsang:web_shooters',
                    'fsang:web_shooters2',
                    'fsang:web_shooters3',
                    'fsang:wings',
                    'fsang:wings_vibranium',
                    'fsang:winter_soldier_arm',
                    'fsang:wonder_woman_block'
                ];

                if (target && target.isAlive() && target != entity) {
                    let powers = palladium.powers.getPowerIds(target);
                    let hasHelmet = powers.some(p => p.toString() === 'fsang:magneto_helmet');

                    if (hasHelmet) {
                        entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Target: ","color":"gray"},{"text":"???","color":"white"}]`);
                        entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Power: ","color":"gray"},{"text":"???","color":"yellow"}]`);
                        return;
                    }

                    entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Target: ","color":"gray"},{"text":"${target.name.string}","color":"white"}]`);

                    powers.forEach(power => {
                        let powerId = power.toString();
                        if (!blacklist.includes(powerId)) {
                            entity.server.runCommandSilent(`execute as ${entity.name.string} run tellraw @s [{"text":"Power: ","color":"gray"},{"text":"${powerId}","color":"yellow"}]`);
                        }
                    });
                }
            });
    });
})();

// kubejs/startup_scripts/list_power.js
(function () {
    // Keep identifiers unique and simple (no optional chaining / nullish coalescing)
    var FSANG_POWER_BLACKLIST = Object.freeze([
        'fsang:absolute_superman_suit',
        'fsang:age',
        'fsang:apocalypse_gift',
        'fsang:asgardian_effect',
        'fsang:batman_beyond_suit',
        'fsang:batman_tools',
        'fsang:capes',
        'fsang:charged_tools',
        'fsang_hero:dampened',
        'fsang:decay_effect',
        'fsang:energy_weapons',
        'fsang:fabricator',
        'fsang:freeze_effect',
        'fsang:gamma_radiation',
        'fsang:grant_x_gene',
        'fsang:hellfire_weapons',
        'fsang:hive_removal',
        'fsang:ice_weapons',
        'fsang:inhibitor_collar',
        'fsang:inhibitor_collar_attempt',
        'fsang:inhibitor_collar_attempt2',
        'fsang:inhibitor_collar_attempt3',
        'fsang:inhibitor_collar_attempt4',
        'fsang:iron_man',
        'fsang:iron_man_ai_chip',
        'fsang:iron_man_model_1',
        'fsang:iron_man_model_2',
        'fsang:iron_man_model_3',
        'fsang:iron_man_model_4',
        'fsang:iron_man_model_71',
        'fsang:iron_man_shield',
        'fsang:iron_man_suits',
        'fsang:kryptonite_weapons',
        'fsang:magnetic_hold',
        'fsang:magnetism_effect',
        'fsang:magneto_helmet',
        'fsang:mindless_attack',
        'fsang:negative_speedforce_chem',
        'fsang:phasing_effect',
        'fsang:phoenix_healing',
        'fsang:picotech_suit',
        'fsang:power_reset',
        'fsang:power_supression',
        'fsang:psychic_damage',
        'fsang:reality_warping_remove_power',
        'fsang:shazam_staff',
        'fsang:shock_effect',
        'fsang:slow_time_effect',
        'fsang:sonic_gun',
        'fsang:sound_effect',
        'fsang:space_power',
        'fsang:speed_transfer_effect',
        'fsang:speedster_chem',
        'fsang:spawn_gift',
        'fsang:speedforce_changer',
        'fsang:spider_serum',
        'fsang:superman_black_solar',
        'fsang:symbiote_enhancement',
        'fsang:symbiote_sickness',
        'fsang:tachyon_device',
        'fsang:tachyon_reactor',
        'fsang:tactile_telekinesis_stun',
        'fsang:telekinetic_hold',
        'fsang:telepathy_motion',
        'fsang:time_effect',
        'fsang:uncontrollable_movement',
        'fsang:uru_apple',
        'fsang:utility_belt',
        'fsang:vibranium_shield',
        'fsang:web_armor',
        'fsang:web_bat',
        'fsang:web_shooters',
        'fsang:web_shooters2',
        'fsang:web_shooters3',
        'fsang:wings',
        'fsang:wings_vibranium',
        'fsang:winter_soldier_arm',
        'fsang:wonder_woman_block'
    ]);

    function FSANG__nameOf(entity) {
        try {
            if (entity && entity.getName && entity.getName()) {
                var comp = entity.getName();
                if (comp && comp.getString) return comp.getString();
            }
            if (entity && entity.name && entity.name.string) return entity.name.string;
        } catch (e) { }
        return 'Unknown';
    }

    function FSANG__actionbar(entity, msg) {
        var srv = entity && entity.server ? entity.server
            : (entity && entity.level && entity.level.getServer ? entity.level.getServer() : null);
        if (!srv) return;

        var who = (entity && entity.uuid) ? entity.uuid : (entity && entity.username ? entity.username : null);
        if (!who) return;

        var json = JSON.stringify({ text: msg, color: 'white' });
        srv.runCommandSilent('execute as ' + who + ' run title @s actionbar ' + json);
    }

    StartupEvents.registry('palladium:abilities', function (event) {
        event.create('fsang:list_power')
            .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
            .addProperty('range', 'float', 10.0, 'Raytrace range to inspect target')
            .tick(function (entity, entry, holder, enabled) {
                if (!enabled) return;

                // light throttle
                var ticks = (entity && entity.tickCount != null) ? entity.tickCount : 0;
                if (ticks % 5 !== 0) return;

                var propRange = entry.getPropertyByName('range');
                var range = (propRange != null) ? propRange : 10.0;

                var hit = entity.rayTrace(range);
                var target = (hit && hit.entity && hit.entity.isAlive() && hit.entity !== entity) ? hit.entity : null;
                if (!target) return;

                // helmet obfuscation
                var obfuscate = false;
                try {
                    var pids = (palladium && palladium.powers && palladium.powers.getPowerIds)
                        ? palladium.powers.getPowerIds(target) : [];
                    if (pids && pids.length) {
                        for (var i = 0; i < pids.length; i++) {
                            var pid = '' + pids[i];
                            if (pid === 'fsang:magneto_helmet') { obfuscate = true; break; }
                        }
                    }
                } catch (e) { }

                if (obfuscate) {
                    FSANG__actionbar(entity, 'Target: ??? | Powers: ???');
                    return;
                }

                // gather + filter powers
                var powerIds = [];
                try {
                    powerIds = (palladium && palladium.powers && palladium.powers.getPowerIds)
                        ? palladium.powers.getPowerIds(target) : [];
                } catch (e) { }

                var clean = [];
                if (powerIds && powerIds.length) {
                    for (var j = 0; j < powerIds.length; j++) {
                        var id = '' + powerIds[j];
                        if (FSANG_POWER_BLACKLIST.indexOf(id) === -1) clean.push(id);
                    }
                }

                // compose succinct line for actionbar
                var MAX = 8;
                var shownList = clean.slice(0, MAX);
                var tail = (clean.length > shownList.length) ? (' …+' + (clean.length - shownList.length)) : '';
                var targetName = FSANG__nameOf(target).replace(/"/g, '\\"');
                var msg = 'Target: ' + targetName + ' | Powers: ' + (shownList.length ? shownList.join(', ') : 'None') + tail;

                FSANG__actionbar(entity, msg);
            });
    });
})();
