StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:mine_block')
        .icon(palladium.createItemIcon('minecraft:iron_pickaxe'))
        .documentationDescription('Mines the block the player is looking at within a set range (excluding air and bedrock).')
        .addProperty('range', 'float', 5.0, 'Maximum distance the block can be from the player')
        .addProperty('drop_items', 'boolean', true, 'Whether the block drops its normal items')
        .tick((entity, entry, holder, enabled) => {
            if (!enabled || !entity.isPlayer()) return;

            const trace = entity.rayTrace(entry.getPropertyByName('range'));
            if (!trace?.block) return;

            const block = entity.level.getBlock(trace.block.pos);
            if (!block || block.id === 'minecraft:air' || block.id === 'minecraft:bedrock') return;

            const { x, y, z } = trace.block.pos;

            if (entry.getPropertyByName('drop_items')) {
                const nsPath = block.id.split(':');
                if (nsPath.length === 2) {
                    entity.server.runCommandSilent(`loot spawn ${x} ${y} ${z} loot ${nsPath[0]}:blocks/${nsPath[1]}`);
                }
            }

            entity.server.runCommandSilent(`setblock ${x} ${y} ${z} air`);
        });
});
