

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('fsang:palladium_property_increase')
        .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
        .addProperty("property", "string", "your_pp", "adds / subtracts from a palladium property")
        .addProperty("auto_increase_per_tick", "integer", 1, "Amount the ability will add per tick")
        .addProperty("max", "integer", 1500, "Max amount it can be.")
        .addProperty("min", "integer", 0, "Min amount it can be.")
        .addProperty("hidden", "boolean", true, "Determines if the ability is visible in the powers screen")
        .addProperty("hidden_in_bar", "boolean", true, "Determines if the ability is visible in the ability bar on your screen")
        .tick((entity, entry, holder, enabled) => {
            if (enabled) {
                const property = entry.getPropertyByName('property');
                const max = entry.getPropertyByName('max');
                const min = entry.getPropertyByName('min');
                let true_property = palladium.getProperty(entity, property);
                if (true_property > max) {
                    palladium.setProperty(entity, property, max);
                }
                if (true_property < min) {
                    palladium.setProperty(entity, property, min);
                }
                const auto_increase_per_tick = entry.getPropertyByName('auto_increase_per_tick');
                palladium.setProperty(entity, property, palladium.getProperty(entity, property) + (auto_increase_per_tick));
            }
        });
    event.create('fsang:palladium_property_modifier')
        .icon(palladium.createItemIcon('minecraft:command_block'))
        .addProperty('property_name', 'string', 'example_property', 'Name of the property to modify')
        .addProperty('adjustment_type', 'string', 'add', 'add, subtract or set')
        .addProperty('adjustment_amount', 'integer', 1, 'Amount to adjust')

        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                const sbName = entry.getPropertyByName('property_name');
                const adjustType = entry.getPropertyByName('adjustment_type');
                const adjustAmt = entry.getPropertyByName('adjustment_amount');

                let currentScore = palladium.getProperty(entity, sbName);

                if (adjustType === 'add') {
                    palladium.setProperty(entity, sbName, currentScore + (adjustAmt));
                } else if (adjustType === 'subtract') {
                    palladium.setProperty(entity, sbName, currentScore - (adjustAmt));
                } else if (adjustType === 'set') {
                    palladium.setProperty(entity, sbName, adjustAmt);
                }
            }
        });
    event.create('fsang:palladium_property_string_modifier')
        .icon(palladium.createItemIcon('minecraft:command_block'))
        .addProperty('property_name', 'string', 'example_property', 'Name of the property to modify')
        .addProperty('adjustment_value', 'string', 'minecraft:air', 'String value to set')

        .tick((entity, entry, holder, enabled) => {
            if (enabled && entity.isPlayer()) {
                const sbName = entry.getPropertyByName('property_name');
                const adjustAmt = entry.getPropertyByName('adjustment_value');
                const player = entity;

                let scoreboard = Utils.server.scoreboard;
                let sbObj = scoreboard.getObjective(sbName);

                if (sbObj != null) {
                    let score = scoreboard.getOrCreatePlayerScore(player.getGameProfile().getName(), sbObj);
                    let currentScore = score.getScore();


                    palladium.setProperty(entity, property, adjustAmt);
                }
            }
        });

});

StartupEvents.registry('palladium:condition_serializer', (event) => {
    event.create('fsang:has_property')
        .addProperty("property", "string", "fsang_property", "The name of the property to look for")
        .addProperty("property_value", "string", "fsang_property_value", "The value of the property to return")
        .test((entity, props) => {
            let PallProp = props.get("property");
            let PallPropValue = props.get("property_value");
            if (palladium.getProperty(entity, PallProp) == PallPropValue) {
                return true
            }
            else {
                return false
            }
        })
});