const AABB = Java.loadClass('net.minecraft.world.phys.AABB');
const Entity = Java.loadClass('net.minecraft.world.entity.Entity');
const EntityType = Java.loadClass('net.minecraft.world.entity.EntityType');

StartupEvents.registry('palladium:abilities', event => {
    event.create('fsang:copy_property_to_nearest')
        .icon(palladium.createItemIcon('minecraft:name_tag'))
        .documentationDescription('Copies a Palladium property from the user to the nearest entity of a specified type within range.')
        .addProperty('target_entity_type', 'string', 'minecraft:player', 'Target entity type ID (e.g., minecraft:zombie)')
        .addProperty('source_property', 'string', 'minecraft:air', 'Player property key to read')
        .addProperty('target_property', 'string', 'minecraft:air', 'Target property key to set')
        .addProperty('range', 'float', 8.0, 'Search radius in blocks')
        .addProperty('exclude_self', 'boolean', true, 'Exclude the user when targeting players')
        .addProperty('only_if_different', 'boolean', true, 'Only set when the value differs')
        .addProperty('scale', 'float', 1.0, 'Multiplier applied if the value is numeric')
        .tick((entity, entry, holder, enabled) => {
            if (!enabled) return;
            const typeId = entry.getPropertyByName('target_entity_type');
            const sourceKey = entry.getPropertyByName('source_property');
            const targetKey = entry.getPropertyByName('target_property');
            const range = entry.getPropertyByName('range');
            const excludeSelf = entry.getPropertyByName('exclude_self');
            const onlyIfDifferent = entry.getPropertyByName('only_if_different');
            const scale = entry.getPropertyByName('scale');

            if (sourceKey === 'minecraft:air' || targetKey === 'minecraft:air') return;
            const targetType = EntityType.byString(typeId).orElse(null);
            if (targetType == null) return;

            const lvl = entity.level;
            if (!lvl || lvl.isClientSide()) return;

            const aabb = new AABB(entity.x - range, entity.y - range, entity.z - range, entity.x + range, entity.y + range, entity.z + range);
            const list = lvl.getEntitiesOfClass(Entity, aabb, e => {
                if (excludeSelf && e.getId() === entity.getId()) return false;
                return e.getType() === targetType;
            });

            if (!list || list.length === 0) return;

            let nearest = null;
            let best = Number.POSITIVE_INFINITY;
            for (let i = 0; i < list.length; i++) {
                const e = list[i];
                const d = e.distanceToSqr(entity.x, entity.y, entity.z);
                if (d < best) {
                    best = d;
                    nearest = e;
                }
            }
            if (nearest == null) return;

            let value = palladium.getProperty(entity, sourceKey);
            if (typeof value === 'number') value = value * scale;

            if (onlyIfDifferent) {
                const cur = palladium.getProperty(nearest, targetKey);
                if (cur === value) return;
            }
            palladium.setProperty(nearest, targetKey, value);
        });
});
